/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.actionlanguage;

import emi.serializer.actionlanguage.C.AtomC;
import emi.serializer.model.ModelLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class AtomSerializer {
    public static final String ATOMS_DIR = "atoms/";
    public static final String ATOMS_GEN = "gen/";
    public static final String ATOM_PREFIX = "atom_";
    private Resource emfModel;
    private String outPath;
    private String target;

    public Resource init(String emiModel, String modelName, String target) throws IOException {
        Resource _xblockexpression = null;
        this.target = target;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(emiModel);
        _builder.append("/");
        _builder.append(ATOMS_DIR);
        _builder.append(ATOMS_GEN);
        _builder.append(target);
        this.outPath = _builder.toString();
        File outFile = new File(this.outPath);
        if (!(outFile.exists() && outFile.isDirectory() || new File(this.outPath).mkdir())) {
            throw new IOException(emiModel + " is not a valid EMI model (" + this.outPath + " cannot be created)");
        }
        String umlFile = emiModel + "/uml/" + modelName + ".uml";
        Resource _xtrycatchfinallyexpression = null;
        try {
            _xtrycatchfinallyexpression = this.emfModel = new ModelLoader().load(umlFile);
        }
        catch (Throwable _t) {
            if (_t instanceof RuntimeException) {
                RuntimeException e = (RuntimeException)_t;
                String _message = e.getMessage();
                String _plus = umlFile + " is not a valid UML model (" + _message;
                String _plus_1 = _plus + ")";
                throw new IOException(_plus_1);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        _xblockexpression = _xtrycatchfinallyexpression;
        return _xblockexpression;
    }

    public void serialize(String stringCode, String id) {
        try {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(this.outPath);
            _builder.append("/");
            _builder.append(ATOM_PREFIX);
            _builder.append(id);
            _builder.append(".c");
            String outFileC = _builder.toString();
            String sOutput = new AtomC(this.emfModel).serialize(stringCode, id, this.target);
            FileOutputStream _fileOutputStream = new FileOutputStream(outFileC);
            PrintStream outC = new PrintStream(_fileOutputStream);
            outC.print(sOutput);
            outC.close();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

