/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer;

import emi.serializer.identifiers.IdentifiersSerializer;
import emi.serializer.metamodel.MetamodelSerializer;
import emi.serializer.metamodel.MetamodelTable;
import emi.serializer.metamodel.OffsetsTableStrategy;
import emi.serializer.model.ModelLoader;
import emi.serializer.model.ModelSerializer;
import emi.serializer.types.Types;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class Main {
    public static void main(String[] args) {
        try {
            boolean _equals_1;
            boolean _not;
            String inFile;
            File umlModelFile;
            if (args.length < 1 || args.length > 2) {
                System.err.println("error: This program expects as parameters the model to serialize and the output directory (optional parameter)");
                System.exit(1);
            }
            if (!(umlModelFile = new File(inFile = args[0])).exists() || !umlModelFile.isFile()) {
                System.err.println("error: " + inFile + " is not a file");
                System.exit(1);
            }
            String model = inFile.replaceAll(".*/", "");
            String modelName = model.replaceAll("\\..*", "");
            String modelExtension = model.replaceAll(".*\\.", "");
            boolean _equals = modelExtension.equals("uml");
            boolean bl = _not = !_equals;
            if (_not) {
                System.err.println("error: The input model is not a UML model. Extension is ." + modelExtension + " but expected .uml");
                System.exit(1);
            }
            File emiModelDir = null;
            int _length = args.length;
            boolean bl2 = _equals_1 = _length == 2;
            if (_equals_1) {
                File _file;
                String inOutputDir = args[1];
                File inOutputDirFile = new File(inOutputDir);
                if (!inOutputDirFile.exists() || !inOutputDirFile.isDirectory()) {
                    System.err.println("error: " + inOutputDir + " is not a directory");
                    System.exit(1);
                }
                StringConcatenation _builder = new StringConcatenation();
                _builder.append(inOutputDir);
                _builder.append("/");
                _builder.append(modelName);
                _builder.append(".emi");
                emiModelDir = _file = new File(_builder.toString());
            }
            if (emiModelDir == null) {
                File _file_1;
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append(modelName);
                _builder_1.append(".emi");
                emiModelDir = _file_1 = new File(_builder_1.toString());
            }
            emiModelDir.mkdir();
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append((Object)emiModelDir);
            _builder_2.append("/");
            _builder_2.append("atoms/");
            File emiModelAtomsDir = new File(_builder_2.toString());
            emiModelAtomsDir.mkdir();
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append((Object)emiModelDir);
            _builder_3.append("/src");
            File emiModelSrcDir = new File(_builder_3.toString());
            emiModelSrcDir.mkdir();
            StringConcatenation _builder_4 = new StringConcatenation();
            _builder_4.append((Object)emiModelDir);
            _builder_4.append("/uml");
            File emiModelUmlDir = new File(_builder_4.toString());
            emiModelUmlDir.mkdir();
            StringConcatenation _builder_5 = new StringConcatenation();
            _builder_5.append((Object)emiModelSrcDir);
            _builder_5.append("/model.c");
            String outFileModelC = _builder_5.toString();
            StringConcatenation _builder_6 = new StringConcatenation();
            _builder_6.append((Object)emiModelSrcDir);
            _builder_6.append("/model.h");
            String outFileModelH = _builder_6.toString();
            StringConcatenation _builder_7 = new StringConcatenation();
            _builder_7.append((Object)emiModelSrcDir);
            _builder_7.append("/types_calibration.h");
            String outFileTypes = _builder_7.toString();
            StringConcatenation _builder_8 = new StringConcatenation();
            _builder_8.append((Object)emiModelSrcDir);
            _builder_8.append("/metamodel.h");
            String outFileMetamodelH = _builder_8.toString();
            StringConcatenation _builder_9 = new StringConcatenation();
            _builder_9.append((Object)emiModelSrcDir);
            _builder_9.append("/metamodel.c");
            String outFileMetamodelC = _builder_9.toString();
            StringConcatenation _builder_10 = new StringConcatenation();
            _builder_10.append((Object)emiModelAtomsDir);
            _builder_10.append("/identifiers.h");
            String outFileIdentifiers = _builder_10.toString();
            ModelLoader modelLoader = new ModelLoader();
            Resource r = modelLoader.load(inFile);
            MetamodelTable metamodelTable = new MetamodelTable();
            metamodelTable.generate();
            OffsetsTableStrategy strategy = new OffsetsTableStrategy(metamodelTable);
            ModelSerializer modelSerializer = new ModelSerializer(r, metamodelTable, strategy);
            MetamodelSerializer metamodelSerializer = new MetamodelSerializer(r, metamodelTable, strategy);
            Types typesSerializer = new Types(r);
            IdentifiersSerializer identifiersSerializer = new IdentifiersSerializer(r);
            String sMetamodelC = metamodelSerializer.serialize();
            String sMetamodelH = metamodelSerializer.serializeHeaders();
            String sModelC = modelSerializer.serialize();
            String sModelH = modelSerializer.serializeHeaders();
            String sTypes = typesSerializer.serialize();
            String sIdentifiers = identifiersSerializer.serialize();
            Main.writeInFile(outFileMetamodelH, sMetamodelH);
            Main.writeInFile(outFileMetamodelC, sMetamodelC);
            Main.writeInFile(outFileModelC, sModelC);
            Main.writeInFile(outFileModelH, sModelH);
            Main.writeInFile(outFileTypes, sTypes);
            Main.writeInFile(outFileIdentifiers, sIdentifiers);
            InputStream makefileEmi = Main.class.getClass().getResourceAsStream("/makefiles/Makefile");
            StringConcatenation _builder_11 = new StringConcatenation();
            String _canonicalPath = emiModelDir.getCanonicalPath();
            _builder_11.append(_canonicalPath);
            _builder_11.append("/Makefile");
            File emiModelDirMakefile = new File(_builder_11.toString());
            Files.copy(makefileEmi, emiModelDirMakefile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            InputStream makefileConfig = Main.class.getClass().getResourceAsStream("/makefiles/Makefile.config");
            StringConcatenation _builder_12 = new StringConcatenation();
            String _canonicalPath_1 = emiModelDir.getCanonicalPath();
            _builder_12.append(_canonicalPath_1);
            _builder_12.append("/Makefile.config");
            File emiModelDirMakefileConfig = new File(_builder_12.toString());
            Files.copy(makefileConfig, emiModelDirMakefileConfig.toPath(), StandardCopyOption.REPLACE_EXISTING);
            InputStream makefileSrc = Main.class.getClass().getResourceAsStream("/makefiles/src/Makefile");
            StringConcatenation _builder_13 = new StringConcatenation();
            String _canonicalPath_2 = emiModelSrcDir.getCanonicalPath();
            _builder_13.append(_canonicalPath_2);
            _builder_13.append("/Makefile");
            File emiModelSrcDirMakefile = new File(_builder_13.toString());
            Files.copy(makefileSrc, emiModelSrcDirMakefile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            InputStream makefileAtoms = Main.class.getClass().getResourceAsStream("/makefiles/atoms/Makefile");
            StringConcatenation _builder_14 = new StringConcatenation();
            String _canonicalPath_3 = emiModelAtomsDir.getCanonicalPath();
            _builder_14.append(_canonicalPath_3);
            _builder_14.append("/Makefile");
            File emiModelAtomsDirMakefile = new File(_builder_14.toString());
            Files.copy(makefileAtoms, emiModelAtomsDirMakefile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            StringConcatenation _builder_15 = new StringConcatenation();
            String _canonicalPath_4 = emiModelUmlDir.getCanonicalPath();
            _builder_15.append(_canonicalPath_4);
            _builder_15.append("/");
            _builder_15.append(modelName);
            _builder_15.append(".uml");
            File emiModelUmlDirModel = new File(_builder_15.toString());
            Files.copy(umlModelFile.toPath(), emiModelUmlDirModel.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private static void writeInFile(String filename, String s) {
        try {
            FileOutputStream _fileOutputStream = new FileOutputStream(filename);
            PrintStream file = new PrintStream(_fileOutputStream);
            file.print(s);
            file.close();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

