/*
 * Decompiled with CFR 0.152.
 */
package plug.language.emi.translator;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import plug.core.view.ConfigurationItem;

public class PlugConfigurationJson {
    public ConfigurationItem deserialize(String config) {
        JsonReader reader = Json.createReader((Reader)new StringReader(config));
        JsonObject object = reader.readObject();
        reader.close();
        ConfigurationItem tree = this.deserialize(object);
        tree.setExpanded(true);
        return tree;
    }

    private ConfigurationItem deserialize(JsonObject object) {
        String name = object.getString("name");
        String type = object.getString("type");
        String value = "";
        try {
            value = object.getString("value");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        String nameLabel = name;
        if (!value.contentEquals("")) {
            nameLabel = nameLabel.concat(" = " + value);
        }
        ArrayList<ConfigurationItem> children = new ArrayList<ConfigurationItem>();
        block7: for (Map.Entry entry : object.entrySet()) {
            switch (((JsonValue)entry.getValue()).getValueType()) {
                case STRING: {
                    break;
                }
                case OBJECT: {
                    children.add(this.deserialize((JsonObject)entry.getValue()));
                    break;
                }
                case ARRAY: {
                    JsonArray array = (JsonArray)entry.getValue();
                    for (int i = 0; i < array.size(); ++i) {
                        children.add(this.deserialize(array.getJsonObject(i)));
                    }
                    continue block7;
                }
                default: {
                    System.err.println("Default case in Json configuration deserialization.");
                }
            }
        }
        ConfigurationItem item = new ConfigurationItem(type, nameLabel, null, children);
        return item;
    }
}

