/*
 * Decompiled with CFR 0.152.
 */
package plug.language.emi.runtime;

import emi.analysis.client.EMISynchronousClient;
import emi.analysis.exception.EMIException;
import emi.analysis.model.EMIConfiguration;
import emi.analysis.model.EMIFireableTransition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import plug.core.IAtomicPropositionsEvaluator;
import plug.core.IFiredTransition;
import plug.core.ITransitionRelation;
import plug.language.emi.analysis.EMIAtomicPropositionEvaluator;
import plug.language.emi.model.PlugRuntimeConfiguration;
import plug.statespace.transitions.FiredTransition;

public class EMIRuntime
implements ITransitionRelation<PlugRuntimeConfiguration, EMIFireableTransition> {
    private EMISynchronousClient client;
    private EMIAtomicPropositionEvaluator propositionEvaluator;

    public EMIRuntime(EMISynchronousClient client) {
        this.client = client;
        try {
            this.client.startDiffMode();
        }
        catch (EMIException e) {
            e.printStackTrace();
        }
        this.propositionEvaluator = new EMIAtomicPropositionEvaluator(this.client);
    }

    public void close() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean initializeRuntime() {
        return true;
    }

    public synchronized Set<PlugRuntimeConfiguration> initialConfigurations() {
        EMIConfiguration initialConfiguration = null;
        try {
            initialConfiguration = this.client.reset();
        }
        catch (EMIException e) {
            e.printStackTrace();
        }
        return Collections.singleton(new PlugRuntimeConfiguration(initialConfiguration));
    }

    public synchronized Collection<EMIFireableTransition> fireableTransitionsFrom(PlugRuntimeConfiguration configuration) {
        ArrayList fts = null;
        try {
            fts = this.client.getFireableTransitions(configuration.getEMIConfiguration());
        }
        catch (EMIException e) {
            e.printStackTrace();
        }
        return fts;
    }

    public synchronized IFiredTransition<PlugRuntimeConfiguration, EMIFireableTransition> fireOneTransition(PlugRuntimeConfiguration source, EMIFireableTransition transition) {
        EMIConfiguration target = null;
        try {
            target = this.client.fireTransition(transition, source.getEMIConfiguration());
        }
        catch (EMIException e) {
            e.printStackTrace();
        }
        return new FiredTransition((Object)source, (Object)new PlugRuntimeConfiguration(target), (Object)transition);
    }

    public synchronized String getTranslation(EMIConfiguration configuration) {
        String s;
        try {
            s = this.client.getTranslation(configuration);
        }
        catch (EMIException e) {
            s = "*** translation error ***";
        }
        return s;
    }

    public synchronized String getTranslation(EMIFireableTransition transition) {
        String s;
        try {
            s = this.client.getTranslation(transition);
        }
        catch (EMIException e) {
            s = "*** translation error ***";
        }
        return s;
    }

    public EMISynchronousClient getClient() {
        return this.client;
    }

    public IAtomicPropositionsEvaluator<PlugRuntimeConfiguration, EMIFireableTransition> getAtomicPropositionEvaluator() {
        return this.propositionEvaluator;
    }
}

