/*
 * Decompiled with CFR 0.152.
 */
package plug.language.emi.analysis;

import emi.analysis.model.EMIFireableTransition;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import plug.core.ILanguagePlugin;
import plug.core.IStateSpaceManager;
import plug.core.ITransitionRelation;
import plug.core.RuntimeDescription;
import plug.events.PropertyEvent;
import plug.explorer.BFSExplorer;
import plug.explorer.buchi.nested_dfs.BA_GaiserSchwoon_Iterative;
import plug.explorer.buchi.nested_dfs.BA_GaiserSchwoon_Recursive;
import plug.language.buchi.runtime.BuchiRuntime;
import plug.language.buchikripke.runtime.KripkeBuchiProductSemantics;
import plug.language.emi.EMIPlugin;
import plug.language.emi.model.PlugRuntimeConfiguration;
import plug.language.emi.runtime.EMIRuntime;
import plug.statespace.IGraphAccess;
import plug.statespace.SimpleStateSpaceManager;
import plug.verifiers.deadlock.DeadlockVerifier;
import plug.verifiers.deadlock.FinalStateDetected;
import plug.visualisation.StateSpace2DOT;
import plug.visualisation.StateSpace2MTX;
import plug.visualisation.StateSpace2TGF;
import properties.BuchiAutomata.BuchiAutomataModel.BuchiDeclaration;
import properties.LTL.parser.Parser;
import properties.LTL.transformations.LTL2Buchi;
import properties.PropositionalLogic.PropositionalLogicModel.DeclarationBlock;
import properties.PropositionalLogic.PropositionalLogicModel.Expression;
import properties.PropositionalLogic.PropositionalLogicModel.ExpressionDeclaration;

public class EMIVerifier {
    private ILanguagePlugin<EMIRuntime> module = new EMIPlugin();
    private EMIRuntime runtime;

    public EMIVerifier(EMIRuntime runtime) {
        this.runtime = runtime;
    }

    public BuchiDeclaration getBuchiDeclaration(String ltlFormula) {
        DeclarationBlock propertiesBlock = Parser.parseBlock((String)ltlFormula);
        Expression property = ((ExpressionDeclaration)propertiesBlock.getDeclarations().iterator().next()).getExpression();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8));
        LTL2Buchi convertor = new LTL2Buchi(writer);
        BuchiDeclaration decl = convertor.convert(property);
        return decl;
    }

    public boolean verifyProperty(String ltl, boolean recursive) throws Exception {
        BuchiDeclaration buchiAutomaton = this.getBuchiDeclaration(ltl);
        BuchiRuntime buchiRuntime = new BuchiRuntime(buchiAutomaton);
        RuntimeDescription kripke = new RuntimeDescription(this.module, () -> this.runtime);
        KripkeBuchiProductSemantics kbProductSemantics = new KripkeBuchiProductSemantics(kripke, buchiRuntime);
        BA_GaiserSchwoon_Recursive verifier = null;
        if (recursive) {
            verifier = new BA_GaiserSchwoon_Recursive((ITransitionRelation)kbProductSemantics);
        } else {
            SimpleStateSpaceManager stateSpaceManager = new SimpleStateSpaceManager();
            verifier = new BA_GaiserSchwoon_Iterative((ITransitionRelation)kbProductSemantics, (IStateSpaceManager)stateSpaceManager);
        }
        AtomicBoolean result = new AtomicBoolean(true);
        verifier.getAnnouncer().when(PropertyEvent.class, (announcer, event) -> result.compareAndSet(!event.isVerified(), false));
        System.out.println("Launch verification of property: \"" + ltl + "\"");
        verifier.execute();
        System.out.println("Property is " + (result.get() ? "verified" : "violated") + "\n");
        return result.get();
    }

    public void verifyFile(String filename, boolean recursive) throws Exception {
        File file = new File(filename);
        InputStreamReader streamReader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
        BufferedReader reader = new BufferedReader(streamReader);
        String readLine = null;
        int nbProperties = 0;
        int nbPropertiesVerified = 0;
        try {
            while ((readLine = reader.readLine()) != null) {
                if ("".contentEquals(readLine)) continue;
                ++nbProperties;
                if (!this.verifyProperty(readLine, recursive)) continue;
                ++nbPropertiesVerified;
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            reader.close();
        }
        System.out.println("Verification result : " + nbPropertiesVerified + "/" + nbProperties + " properties verified\n");
    }

    public void detectDeadlocks() {
        SimpleStateSpaceManager stateSpaceManager = new SimpleStateSpaceManager();
        BFSExplorer explorer = new BFSExplorer((ITransitionRelation)this.runtime, (IStateSpaceManager)stateSpaceManager);
        DeadlockVerifier deadlockVerifier = new DeadlockVerifier(explorer.getAnnouncer());
        AtomicBoolean deadLockFree = new AtomicBoolean(true);
        AtomicInteger nbDeadlocks = new AtomicInteger(0);
        deadlockVerifier.announcer.when(FinalStateDetected.class, (ann, ev) -> {
            deadLockFree.set(false);
            nbDeadlocks.incrementAndGet();
        });
        System.out.println("Launch deadlock detection.");
        explorer.execute();
        System.out.println("Detection result: " + nbDeadlocks.get() + " deadlocks detected.\n");
    }

    public void exploreStateSpace(boolean deadlockDetection, boolean exportStateSpace) {
        SimpleStateSpaceManager stateSpaceManager = new SimpleStateSpaceManager();
        stateSpaceManager.fullConfigurationStorage();
        stateSpaceManager.fullTransitionStorage();
        BFSExplorer explorer = new BFSExplorer((ITransitionRelation)this.runtime, (IStateSpaceManager)stateSpaceManager);
        AtomicBoolean deadLockFree = new AtomicBoolean(true);
        AtomicInteger nbDeadlocks = new AtomicInteger(0);
        DeadlockVerifier deadlockVerifier = new DeadlockVerifier(explorer.getAnnouncer());
        if (deadlockDetection) {
            deadlockVerifier.announcer.when(FinalStateDetected.class, (ann, ev) -> {
                deadLockFree.set(false);
                nbDeadlocks.incrementAndGet();
            });
        }
        System.out.println("Launch state-space exploration");
        long timeStart = System.currentTimeMillis();
        explorer.execute();
        long timeEnd = System.currentTimeMillis();
        System.out.println("Exploration result : " + stateSpaceManager.size() + " configurations and " + stateSpaceManager.transitionCount() + " transitions");
        System.out.println("Exploration duration = " + (timeEnd - timeStart) + "ms\n");
        if (deadlockDetection) {
            System.out.println("Detection result: " + nbDeadlocks.get() + " deadlocks detected.\n");
        }
        if (exportStateSpace) {
            this.exportStateSpaceGraph("state_space", (IStateSpaceManager<PlugRuntimeConfiguration, EMIFireableTransition>)stateSpaceManager);
        }
    }

    public void exportStateSpaceGraph(String name, IStateSpaceManager<PlugRuntimeConfiguration, EMIFireableTransition> stateSpaceManager) {
        System.out.println("Print files used for state-space visualization");
        StateSpace2TGF.toTGF((IGraphAccess)stateSpaceManager.getGraphView(), (boolean)true, (String)(name + ".tgf"));
        StateSpace2MTX.toMTX((IGraphAccess)stateSpaceManager.getGraphView(), (String)(name + ".mtx"));
        StateSpace2DOT.toDOT((IGraphAccess)stateSpaceManager.getGraphView(), (boolean)true, (String)(name + ".gv"));
    }
}

