/*
 * Decompiled with CFR 0.152.
 */
package emi.analysis.server.translator;

import emi.analysis.model.EMIConfiguration;
import emi.analysis.server.translator.Translator;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;

public class TranslationBuilderJson
implements Translator.ITranslationBuilder {
    private EMIConfiguration configuration;

    @Override
    public String translate(EMIConfiguration configuration, Translator.MetaECTreeItem treeRoot) {
        this.configuration = configuration;
        JsonObjectBuilder builder = this.generateConfigurationJson(treeRoot);
        return builder.build().toString();
    }

    private JsonObjectBuilder generateConfigurationJson(Translator.MetaECTreeItem item) {
        JsonObjectBuilder itemBuilder = Json.createObjectBuilder();
        itemBuilder.add("type", item.getType());
        itemBuilder.add("name", item.getName());
        if (item.isLeaf()) {
            itemBuilder.add("value", item.computeValue(this.configuration));
        } else {
            JsonArrayBuilder childrenBuilder = Json.createArrayBuilder();
            for (Translator.MetaECTreeItem child : item.getChildren()) {
                childrenBuilder.add(this.generateConfigurationJson(child));
            }
            itemBuilder.add("children", childrenBuilder);
        }
        return itemBuilder;
    }

    @Override
    public String translate(Translator.MetaEFT transition) {
        String name = "";
        if (transition.getName() != null) {
            name = transition.getName();
        }
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("activeObject", transition.getActiveObject());
        builder.add("name", name);
        builder.add("source", transition.getSource());
        builder.add("target", transition.getTarget());
        return builder.build().toString();
    }
}

