/*
 * Decompiled with CFR 0.152.
 */
package emi.analysis.server.atom;

import emi.analysis.com.IConnection;
import emi.analysis.model.EMIAtom;
import emi.analysis.protocol.EMIProtocol;
import emi.analysis.protocol.EMIProtocolAtoms;
import emi.analysis.server.log.Log;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class AtomBank {
    private static final String ATOMS_BUILD = "build/";
    private static final String BANK_FILE = "interpreter.bank";
    private boolean log;
    private IConnection interpreterConnection;
    private String target;
    private String serializedAtomsBuild;
    private int interpreterAtomsBankMax;
    private int interpreterAtomsSizeMax;
    private HashMap<String, EncounteredAtom> encounteredAtoms;
    private EncounteredAtom[] loadedAtoms;
    private int currentIndex;
    private ArrayList<EncounteredAtom> atomsToEvaluate;

    public int getInterpreterAtomsBankMax() {
        return this.interpreterAtomsBankMax;
    }

    public int getInterpreterAtomsSizeMax() {
        return this.interpreterAtomsSizeMax;
    }

    private void currentIndexInc() {
        this.currentIndex = this.currentIndex == this.interpreterAtomsBankMax - 1 ? 0 : this.currentIndex + 1;
    }

    public AtomBank(IConnection interpreterConnection, boolean log) {
        this.log = log;
        this.interpreterConnection = interpreterConnection;
        this.encounteredAtoms = new HashMap();
        this.currentIndex = 0;
    }

    public void init(String emiModel, String target, String serializedAtomsDir) throws IOException {
        this.target = target;
        this.serializedAtomsBuild = serializedAtomsDir + ATOMS_BUILD + target;
        File bankFile = new File(emiModel + "/" + ATOMS_BUILD + target + "/" + BANK_FILE);
        if (!bankFile.exists() || !bankFile.isFile()) {
            throw new IOException("Atom manager: " + bankFile + " is not a valid file");
        }
        DataInputStream stream = new DataInputStream(new BufferedInputStream(new FileInputStream(bankFile)));
        byte[] buffer = new byte[(int)bankFile.length()];
        try {
            stream.readFully(buffer);
        }
        catch (IOException e) {
            throw new IOException("Atom manager: " + e.getMessage());
        }
        finally {
            stream.close();
        }
        String bankString = new String(buffer);
        if (bankString.length() == 0) {
            throw new IOException("Atom manager: " + bankFile + " is an empty file");
        }
        Matcher matcher = Pattern.compile("([\\p{Digit}]+) ([\\p{Digit}]+)$").matcher(bankString);
        if (!matcher.find()) {
            throw new IOException("Atom manager: " + bankFile + " does not provide valid bank data");
        }
        this.interpreterAtomsBankMax = Integer.parseInt(matcher.group(1));
        this.interpreterAtomsSizeMax = Integer.parseInt(matcher.group(2));
        this.loadedAtoms = new EncounteredAtom[this.interpreterAtomsBankMax];
    }

    public void prepareEvaluation() {
        this.atomsToEvaluate = new ArrayList();
    }

    public boolean registerEvaluation(EMIAtom atom) throws IOException {
        EncounteredAtom eAtom = this.encounteredAtoms.get(atom.getIdHexa());
        if (eAtom != null) {
            this.atomsToEvaluate.add(eAtom);
            if (!eAtom.isLoaded()) {
                this.load(eAtom, this.getFirstAvailableBank());
            }
            return true;
        }
        return false;
    }

    public void registerFirstEvaluation(EMIAtom atom) throws IOException {
        EncounteredAtom eAtom = new EncounteredAtom(this, atom);
        this.encounteredAtoms.put(atom.getIdHexa(), eAtom);
        this.atomsToEvaluate.add(eAtom);
        this.load(eAtom, this.getFirstAvailableBank());
    }

    private void load(EncounteredAtom eAtom, int bank) throws IOException {
        if (this.loadedAtoms[bank] != null) {
            this.loadedAtoms[bank].setUnload();
        }
        this.loadedAtoms[bank] = eAtom;
        eAtom.bank = bank;
        if ("host".equals(this.target)) {
            this.loadHost(eAtom, bank);
        } else {
            this.loadEmbedded(eAtom, bank);
        }
    }

    private void loadHost(EncounteredAtom eAtom, int bank) throws IOException {
        EMIProtocol.writeHeader(this.interpreterConnection, new EMIProtocol.Header(14, 20));
        this.interpreterConnection.write(EMIProtocolAtoms.serializeLoad(bank, eAtom.atom));
    }

    private void loadEmbedded(EncounteredAtom eAtom, int bank) throws IOException {
        EMIProtocol.writeHeader(this.interpreterConnection, new EMIProtocol.Header(14, 4 + eAtom.binaryCode.length));
        this.interpreterConnection.write(EMIProtocolAtoms.serializeLoad(bank, eAtom.binaryCode));
    }

    private int getFirstAvailableBank() {
        int index;
        if (this.loadedAtoms[this.currentIndex] == null) {
            index = this.currentIndex;
        } else {
            while (this.atomsToEvaluate.contains(this.loadedAtoms[this.currentIndex])) {
                this.currentIndexInc();
            }
            index = this.currentIndex;
        }
        this.currentIndexInc();
        return index;
    }

    public void evaluate() throws IOException {
        if (this.log) {
            this.logLoadedAtoms();
        }
        EMIProtocol.writeHeader(this.interpreterConnection, new EMIProtocol.Header(15, this.atomsToEvaluate.size() * 4));
        this.interpreterConnection.write(EMIProtocolAtoms.serializeAtomsToEvaluate(this.atomsToEvaluate));
    }

    private void logLoadedAtoms() {
        for (int i = 0; i < this.interpreterAtomsBankMax; ++i) {
            if (this.loadedAtoms[i] == null) {
                Log.d("Loaded atom [" + i + "]: null");
                continue;
            }
            Log.d("Loaded atom [" + i + "]: " + (this.atomsToEvaluate.contains(this.loadedAtoms[i]) ? "*" : " ") + this.loadedAtoms[i].atom.toString());
        }
    }

    private static final class EncounteredAtom
    implements EMIProtocolAtoms.AtomBankable {
        private static final String COMPILATION_CODE_SUFFIX = ".bin";
        private EMIAtom atom;
        private int bank;
        private byte[] binaryCode;

        private EncounteredAtom(AtomBank atomBank, EMIAtom atom) throws IOException {
            this.atom = atom;
            this.bank = -1;
            if (!"host".equals(atomBank.target)) {
                this.readBinaryCode(atomBank.serializedAtomsBuild + "/" + "atom_" + atom.getIdHexa() + COMPILATION_CODE_SUFFIX);
            }
        }

        private boolean isLoaded() {
            return this.bank >= 0;
        }

        private void setUnload() {
            this.bank = -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readBinaryCode(String filename) throws IOException {
            File file = new File(filename);
            int fileLength = (int)file.length();
            this.binaryCode = new byte[fileLength];
            try (BufferedInputStream stream = null;){
                stream = new BufferedInputStream(new FileInputStream(file));
                int binaryCodeReadLength = stream.read(this.binaryCode);
                if (binaryCodeReadLength != fileLength) {
                    throw new IOException("Atom manager: read binary code size " + binaryCodeReadLength + " (expected: " + fileLength + ")");
                }
            }
        }

        @Override
        public int getBank() {
            return this.bank;
        }
    }
}

