/*
 * Decompiled with CFR 0.152.
 */
package emi.analysis.server;

import emi.analysis.com.IConnection;
import emi.analysis.model.EMIFireableTransition;
import emi.analysis.protocol.EMIProtocol;
import emi.analysis.protocol.EMIProtocolFireableTransition;
import emi.analysis.protocol.EMIProtocolTranslation;
import emi.analysis.server.EMIServer;
import emi.analysis.server.log.Log;
import emi.analysis.server.translator.Translator;
import emi.analysis.server.translator.TranslatorException;
import java.io.IOException;

public class ServiceTranslateFireableTransition
extends EMIServer.AService {
    private Translator translator;

    public ServiceTranslateFireableTransition(Translator translator, boolean log) {
        super(log);
        this.translator = translator;
        if (this.translator != null) {
            Log.i("Service: translation of fireable transitions");
        }
    }

    @Override
    public void execute(EMIProtocol.Header header, IConnection connection) throws IOException {
        EMIFireableTransition transition = EMIProtocolFireableTransition.deserialize(connection.read(header.size)).get(0);
        try {
            if (this.translator == null) {
                throw new TranslatorException("not available");
            }
            if (this.log || this.translator.hasLog()) {
                Log.d("Service: translate fireable transition (" + transition.toString() + ")");
            }
            String translation = this.translator.translate(transition);
            EMIProtocol.writeHeader(connection, new EMIProtocol.Header(102, translation.length()));
            connection.write(EMIProtocolTranslation.serialize(translation));
        }
        catch (TranslatorException e) {
            Log.e("Translation service: " + e.getMessage());
            EMIProtocol.writeHeader(connection, new EMIProtocol.Header(1));
        }
    }
}

