/*
 * Decompiled with CFR 0.152.
 */
package plug.language.emi.visualization;

import emi.analysis.client.EMISynchronousClient;
import emi.analysis.exception.EMIException;
import emi.analysis.model.EMIFireableTransition;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import plug.core.IFiredTransition;
import plug.language.emi.model.PlugRuntimeConfiguration;
import plug.statespace.IGraphAccess;

public class StateSpace2Json<N, T, J> {
    private StateSpace2Json() {
    }

    public static void toJson(IGraphAccess<PlugRuntimeConfiguration, EMIFireableTransition> graphView, EMISynchronousClient client, String dirname) throws IOException, EMIException {
        HashMap<PlugRuntimeConfiguration, Integer> idMap = new HashMap<PlugRuntimeConfiguration, Integer>();
        File directory = new File(dirname);
        directory.mkdir();
        graphView.getVertices().parallelStream().forEach(vertex -> {
            try {
                StateSpace2Json.writeNode(vertex, dirname, idMap, client);
            }
            catch (EMIException | IOException e) {
                e.printStackTrace();
            }
        });
        BufferedWriter transitionWriter = new BufferedWriter(new FileWriter(dirname + "/transitions.graph"));
        for (PlugRuntimeConfiguration vertex2 : graphView.getInitialVertices()) {
            transitionWriter.write("0 " + StateSpace2Json.getID(vertex2, idMap) + "\n");
        }
        for (PlugRuntimeConfiguration source : graphView.getVertices()) {
            int sourceId = StateSpace2Json.getID(source, idMap);
            for (IFiredTransition transition : graphView.getOutgoingEdges((Object)source)) {
                for (PlugRuntimeConfiguration target : transition.getTargets()) {
                    transitionWriter.write(sourceId + " " + StateSpace2Json.getID(target, idMap) + "\n");
                }
            }
        }
        ((Writer)transitionWriter).close();
    }

    private static int getID(PlugRuntimeConfiguration vertex, Map<PlugRuntimeConfiguration, Integer> idMap) {
        Integer id = idMap.get((Object)vertex);
        if (id == null) {
            id = idMap.size() + 1;
            idMap.put(vertex, id);
        }
        return id;
    }

    private static void writeNode(PlugRuntimeConfiguration node, String dirname, Map<PlugRuntimeConfiguration, Integer> idMap, EMISynchronousClient client) throws EMIException, IOException {
        int id = StateSpace2Json.getID(node, idMap);
        BufferedWriter vertexWriter = new BufferedWriter(new FileWriter(dirname + "/node_" + id + ".json"));
        String content = client.getTranslation(node.getEMIConfiguration());
        vertexWriter.write(content);
        ((Writer)vertexWriter).close();
    }
}

