/*
 * Decompiled with CFR 0.152.
 */
package plug.language.emi.diagnosis;

import emi.analysis.client.EMISynchronousClient;
import emi.analysis.exception.EMIException;
import emi.analysis.model.EMIAtom;
import emi.analysis.model.EMIFireableTransition;
import plug.core.IAtomicPropositionsEvaluator;
import plug.language.emi.model.PlugRuntimeConfiguration;

public class EMIAtomicPropositionEvaluator
implements IAtomicPropositionsEvaluator<PlugRuntimeConfiguration, EMIFireableTransition> {
    private EMISynchronousClient client;
    private EMIAtom[] atoms;

    public EMIAtomicPropositionEvaluator(EMISynchronousClient client) {
        this.client = client;
        this.atoms = new EMIAtom[0];
    }

    public int[] registerAtomicPropositions(String[] strings) {
        int nbAtoms = strings.length;
        int[] ids = new int[nbAtoms];
        this.atoms = new EMIAtom[nbAtoms];
        for (int i = 0; i < strings.length; ++i) {
            try {
                this.atoms[i] = new EMIAtom(strings[i]);
            }
            catch (EMIException e) {
                e.printStackTrace();
            }
            ids[i] = i;
        }
        return ids;
    }

    public boolean[] getAtomicPropositionValuations(PlugRuntimeConfiguration source) {
        if (this.atoms == null) {
            return new boolean[0];
        }
        boolean[] results = null;
        try {
            results = this.client.evaluateAtoms(this.atoms);
        }
        catch (EMIException e) {
            e.printStackTrace();
        }
        return results;
    }
}

