/*
 * Decompiled with CFR 0.152.
 */
package plug.language.emi;

import emi.analysis.client.EMISynchronousClient;
import emi.analysis.exception.EMIException;
import emi.analysis.model.EMIModel;
import emi.analysis.standalone.client.EMISynchronousStandaloneClient;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.ParserProperties;
import plug.core.IStateSpaceManager;
import plug.core.ITransitionRelation;
import plug.explorer.BFSExplorer;
import plug.language.emi.EMIRuntimeOptions;
import plug.language.emi.runtime.EMIRuntime;
import plug.statespace.SimpleStateSpaceManager;

public class Main {
    private static EMIRuntimeOptions options;
    private static BufferedWriter writer;
    private static final int HELP_WIDTH = 150;

    private static final boolean manageOptions(String ... args) throws CmdLineException, IOException {
        CmdLineParser parser = new CmdLineParser((Object)options, ParserProperties.defaults().withOptionSorter((Comparator)options));
        try {
            parser.parseArgument(args);
            if (Main.options.help) {
                Main.printHelp(parser);
            }
            if (Main.options.version) {
                Main.printVersion();
            }
            if (Main.options.help || Main.options.version) {
                return false;
            }
            if (Main.options.port == 0) {
                Main.options.port = Main.options.standalone_mode ? 12345 : 12346;
            }
            Main.checkEMIHomeOption(parser);
            Main.checkEMIModelOption(parser);
        }
        catch (CmdLineException e) {
            Main.printHelp(parser);
            throw e;
        }
        return true;
    }

    private static final void checkEMIHomeOption(CmdLineParser parser) throws CmdLineException, IOException {
        if (Main.options.standalone_mode && Main.options.emiHome == null) {
            throw new CmdLineException(parser, "EMI home directory must be set in standalone mode (for atom evaluation)", (Throwable)new Error());
        }
        if (Main.options.emiHome != null) {
            Main.options.emiHome = EMIModel.checkEMIHome((String)Main.options.emiHome);
        }
    }

    private static final void checkEMIModelOption(CmdLineParser parser) throws CmdLineException, IOException {
        if (Main.options.standalone_mode && Main.options.emiModel == null) {
            throw new CmdLineException(parser, "The EMI model must be set in standalone mode (for atom evaluation or for translation)", (Throwable)new Error());
        }
        if (Main.options.emiModel != null) {
            Main.options.emiModel = EMIModel.checkEMIModel((String)Main.options.emiModel);
        }
    }

    private static final void printHelp(CmdLineParser parser) {
        System.out.println("Usage:");
        parser.getProperties().withUsageWidth(150);
        parser.printUsage((OutputStream)System.out);
    }

    private static final void printVersion() {
        System.out.println("Version 0.0.5 (under developement) !");
    }

    private static void openFile(String filemane) {
        try {
            writer = new BufferedWriter(new FileWriter(filemane));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void closeFile() {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static final void main(String[] args) throws IOException {
        block7: {
            options = new EMIRuntimeOptions();
            boolean exit = false;
            try {
                exit = !Main.manageOptions(args);
            }
            catch (IOException | CmdLineException e) {
                System.err.println(e.getMessage());
                exit = true;
            }
            finally {
                if (!exit) break block7;
                return;
            }
        }
        Main.openFile("./state_space_logs.txt");
        Object client = null;
        try {
            client = Main.options.standalone_mode ? new EMISynchronousStandaloneClient(Main.options.address, Main.options.port, Main.options.emiModel, Main.options.emiHome, Main.options.target, Main.options.compiler, Main.options.makeTool, Main.options.dwarfTool) : new EMISynchronousClient(Main.options.address, Main.options.port);
        }
        catch (EMIException e) {
            e.printStackTrace();
            return;
        }
        EMIRuntime runtime = new EMIRuntime((EMISynchronousClient)client);
        SimpleStateSpaceManager stateSpaceManager = new SimpleStateSpaceManager();
        stateSpaceManager.fullConfigurationStorage();
        stateSpaceManager.fullTransitionStorage();
        BFSExplorer explorer = new BFSExplorer((ITransitionRelation)runtime, (IStateSpaceManager)stateSpaceManager);
        long timeStart = System.currentTimeMillis();
        explorer.execute();
        long timeEnd = System.currentTimeMillis();
        Main.closeFile();
        System.out.println("Exploration finished : size = " + stateSpaceManager.size() + " transitions count = " + stateSpaceManager.transitionCount());
        System.out.println("Exploration duration = " + (timeEnd - timeStart) + "ms");
    }
}

