/*
 * Decompiled with CFR 0.152.
 */
package plug.language.emi;

import emi.analysis.model.EMIFireableTransition;
import java.util.Collections;
import java.util.List;
import plug.core.IRuntimeView;
import plug.core.view.ConfigurationItem;
import plug.language.emi.model.PlugRuntimeConfiguration;
import plug.language.emi.runtime.EMIRuntime;
import plug.language.emi.translator.PlugConfigurationJson;
import plug.language.emi.translator.PlugTransitionJson;

public class EMIRuntimeView
implements IRuntimeView<PlugRuntimeConfiguration, EMIFireableTransition> {
    private EMIRuntime runtime;
    private PlugTransitionJson transitionJson;
    private PlugConfigurationJson configurationJson;

    public EMIRuntimeView(EMIRuntime runtime) {
        this.runtime = runtime;
        this.transitionJson = new PlugTransitionJson();
        this.configurationJson = new PlugConfigurationJson();
    }

    public EMIRuntime getRuntime() {
        return this.runtime;
    }

    public List<ConfigurationItem> getConfigurationItems(PlugRuntimeConfiguration value) {
        String s = this.runtime.getTranslation(value.getEMIConfiguration());
        ConfigurationItem item = this.configurationJson.deserialize(s);
        return Collections.singletonList(item);
    }

    public String getFireableTransitionDescription(EMIFireableTransition transition) {
        String s = this.runtime.getTranslation(transition);
        return this.transitionJson.deserialize(s);
    }
}

