/*
 * Decompiled with CFR 0.152.
 */
package plug.language.emi;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.google.common.net.InetAddresses;
import emi.analysis.client.EMISynchronousClient;
import emi.analysis.exception.EMIException;
import emi.analysis.standalone.client.EMISynchronousStandaloneClient;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import plug.core.ILanguageLoader;
import plug.language.emi.runtime.EMIRuntime;
import plug.language.emi.runtime.PropertyKind;
import plug.language.emi.runtime.PropertyManager;

public class EMILoader
implements ILanguageLoader<EMIRuntime> {
    private String lastChecksum = null;
    private EMISynchronousClient client = null;
    private EMIRuntime runtime = null;

    public EMIRuntime getRuntime(URI modelURI, Map<String, Object> options) {
        System.out.println("Get runtime");
        File file = new File(modelURI);
        String checksum = this.getChecksum(file);
        if (this.runtime != null && this.lastChecksum != null && this.lastChecksum.equals(checksum)) {
            System.out.println("Return same runtime");
            return this.runtime;
        }
        if (this.runtime != null) {
            System.out.println("Close runtime");
            this.runtime.close();
            this.runtime = null;
        }
        System.out.println("Load new runtime");
        PropertyManager propManager = new PropertyManager(file);
        try {
            String mode;
            switch (mode = propManager.getProperty(PropertyKind.MODE)) {
                case "remote": {
                    this.initRuntimeInRemoteMode(propManager);
                    break;
                }
                case "standalone": {
                    this.initRuntimeInStandaloneMode(propManager);
                    break;
                }
                default: {
                    throw new EMIException("Unknown mode (only \"remote\" or \"standalone\" are available)");
                }
            }
            this.lastChecksum = this.getChecksum(file);
        }
        catch (EMIException e) {
            e.printStackTrace();
        }
        propManager.close();
        return this.runtime;
    }

    private void initRuntimeInRemoteMode(PropertyManager propManager) {
        try {
            String address = propManager.getProperty(PropertyKind.ADDRESS);
            if (address == null) {
                address = "127.0.0.1";
            }
            String portString = propManager.getProperty(PropertyKind.PORT);
            int port = 0;
            port = portString == null ? 12346 : Integer.parseInt(portString);
            if (!"localhost".contentEquals(address) && !InetAddresses.isInetAddress((String)address)) {
                System.err.println("EMI: address=" + address + " is not an IP address");
                throw new EMIException("Invalid IP address");
            }
            this.client = new EMISynchronousClient(address, port);
            this.runtime = new EMIRuntime(this.client);
        }
        catch (EMIException e) {
            this.runtime = null;
            e.printStackTrace();
        }
    }

    private void initRuntimeInStandaloneMode(PropertyManager propManager) {
        try {
            String address = propManager.getProperty(PropertyKind.ADDRESS);
            if (address == null) {
                address = "127.0.0.1";
            }
            String portString = propManager.getProperty(PropertyKind.PORT);
            int port = 0;
            port = portString == null ? 12345 : Integer.parseInt(portString);
            String emiModel = propManager.getProperty(PropertyKind.EMI_MODEL);
            String emiHome = propManager.getProperty(PropertyKind.EMI_HOME);
            String target = propManager.getProperty(PropertyKind.TARGET);
            String compiler = propManager.getProperty(PropertyKind.COMPILER);
            String makeTool = propManager.getProperty(PropertyKind.MAKE_TOOL);
            String dwarfTool = propManager.getProperty(PropertyKind.DWARF_TOOL);
            if (!"localhost".contentEquals(address) && !InetAddresses.isInetAddress((String)address)) {
                System.err.println("EMI: address=" + address + " is not an IP address");
                throw new EMIException("Invalid IP address");
            }
            this.client = new EMISynchronousStandaloneClient(address, port, emiModel, emiHome, target, compiler, makeTool, dwarfTool);
            this.runtime = new EMIRuntime(this.client);
        }
        catch (EMIException e) {
            this.runtime = null;
            e.printStackTrace();
        }
    }

    private String getChecksum(File file) {
        String checksum = null;
        try {
            HashCode hc = Files.asByteSource((File)file).hash(Hashing.sha256());
            checksum = hc.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return checksum;
    }
}

