/*
 * Decompiled with CFR 0.152.
 */
package plug.ui2.simulation.expression_watcher;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Cell;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.fxmisc.richtext.CodeArea;
import org.kordamp.ikonli.javafx.FontIcon;
import plug.ui2.simulation.expression_watcher.WatchExpression;

class WatchExpressionListCell
extends ListCell<WatchExpression> {
    private CodeArea codeArea;
    private final CheckBox selectedCheckBox = new CheckBox();
    private final Label expressionLabel = new Label();
    private ObservableValue<Boolean> booleanProperty;
    private final FontIcon evaluationResultIcon = new FontIcon("gmi-lens:20");
    private final GridPane mGraphic = new GridPane();
    private ObjectProperty<StringConverter<WatchExpression>> converter = new SimpleObjectProperty((Object)this, "converter");
    private ObjectProperty<Callback<WatchExpression, ObservableValue<Boolean>>> selectedStateCallback = new SimpleObjectProperty((Object)this, "selectedStateCallback");

    public static Callback<ListView<WatchExpression>, ListCell<WatchExpression>> forListView(Callback<WatchExpression, ObservableValue<Boolean>> getSelectedProperty, StringConverter<WatchExpression> converter) {
        return list -> new WatchExpressionListCell(getSelectedProperty, converter);
    }

    public WatchExpressionListCell(Callback<WatchExpression, ObservableValue<Boolean>> getSelectedProperty, StringConverter<WatchExpression> converter) {
        this.getStyleClass().add((Object)"text-field-list-cell");
        this.setConverter(converter);
        this.setSelectedStateCallback(getSelectedProperty);
        this.setAlignment(Pos.CENTER_LEFT);
        this.setContentDisplay(ContentDisplay.LEFT);
        this.mGraphic.add((Node)this.selectedCheckBox, 0, 0);
        this.mGraphic.add((Node)this.expressionLabel, 1, 0);
        this.mGraphic.add((Node)this.evaluationResultIcon, 2, 0);
        ColumnConstraints c1 = new ColumnConstraints();
        ColumnConstraints c2 = new ColumnConstraints();
        c2.setHgrow(Priority.ALWAYS);
        ColumnConstraints c3 = new ColumnConstraints();
        this.mGraphic.setHgap(5.0);
        this.mGraphic.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{c1, c2, c3});
        this.setGraphic(null);
    }

    public final ObjectProperty<StringConverter<WatchExpression>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<WatchExpression> value) {
        this.converterProperty().set(value);
    }

    public final StringConverter<WatchExpression> getConverter() {
        return (StringConverter)this.converterProperty().get();
    }

    public void startEdit() {
        if (!this.isEditable() || !this.getListView().isEditable()) {
            return;
        }
        super.startEdit();
        if (this.isEditing()) {
            if (this.codeArea == null) {
                this.codeArea = new CodeArea(this.getItemText((Cell<WatchExpression>)this, this.getConverter()));
                KeyCodeCombination saveKeyCombination = new KeyCodeCombination(KeyCode.ENTER, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                this.codeArea.setOnKeyReleased(arg_0 -> this.lambda$startEdit$1((KeyCombination)saveKeyCombination, arg_0));
            }
            this.setText(null);
            this.setGraphic((Node)this.codeArea);
            this.codeArea.selectAll();
            this.codeArea.requestFocus();
            this.codeArea.setPrefHeight(60.0);
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.updateItem((WatchExpression)this.getItem(), false);
    }

    String getItemText(Cell<WatchExpression> cell, StringConverter<WatchExpression> converter) {
        return converter == null ? (cell.getItem() == null ? "" : ((WatchExpression)cell.getItem()).toString()) : converter.toString(cell.getItem());
    }

    public final ObjectProperty<Callback<WatchExpression, ObservableValue<Boolean>>> selectedStateCallbackProperty() {
        return this.selectedStateCallback;
    }

    public final void setSelectedStateCallback(Callback<WatchExpression, ObservableValue<Boolean>> value) {
        this.selectedStateCallbackProperty().set(value);
    }

    public final Callback<WatchExpression, ObservableValue<Boolean>> getSelectedStateCallback() {
        return (Callback)this.selectedStateCallbackProperty().get();
    }

    public void updateItem(WatchExpression item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setGraphic(null);
            this.setText(null);
            return;
        }
        StringConverter<WatchExpression> converter = this.getConverter();
        Callback<WatchExpression, ObservableValue<Boolean>> callback = this.getSelectedStateCallback();
        if (callback == null) {
            throw new NullPointerException("The CheckBoxListCell selectedStateCallbackProperty can not be null");
        }
        if (this.isEditing()) {
            if (this.codeArea != null) {
                this.codeArea.replaceText(this.getItemText((Cell<WatchExpression>)this, converter));
            }
            this.setText(null);
            this.setGraphic((Node)this.codeArea);
            return;
        }
        if (item == WatchExpression.NO_EXPRESSION) {
            this.setText("Click to enter a new watch");
            this.setGraphic(null);
            return;
        }
        this.setText(null);
        this.setGraphic((Node)this.mGraphic);
        String text = converter != null ? converter.toString((Object)item) : (item == null ? "" : item.toString());
        this.expressionLabel.setText(text.length() < 28 ? text : text.substring(0, 28) + "...");
        if (this.booleanProperty != null) {
            this.selectedCheckBox.selectedProperty().unbindBidirectional((Property)((BooleanProperty)this.booleanProperty));
        }
        this.booleanProperty = (ObservableValue)callback.call((Object)item);
        if (this.booleanProperty != null) {
            this.selectedCheckBox.selectedProperty().bindBidirectional((Property)((BooleanProperty)this.booleanProperty));
        }
        if (item != null && item.isTrue.get()) {
            this.evaluationResultIcon.setIconColor((Paint)Color.GREEN);
        } else {
            this.evaluationResultIcon.setIconColor((Paint)Color.RED);
        }
        item.isTrue.addListener((v, o, n) -> {
            if (item != null && item.isTrue.get()) {
                this.evaluationResultIcon.setIconColor((Paint)Color.GREEN);
            } else {
                this.evaluationResultIcon.setIconColor((Paint)Color.RED);
            }
        });
    }

    private /* synthetic */ void lambda$startEdit$1(KeyCombination saveKeyCombination, KeyEvent t) {
        if (saveKeyCombination.match(t)) {
            this.commitEdit(this.getConverter().fromString(this.codeArea.getText()));
            t.consume();
        }
        if (t.getCode() == KeyCode.ESCAPE) {
            this.cancelEdit();
            t.consume();
        }
    }
}

