/*
 * Decompiled with CFR 0.152.
 */
package emi.analysis.server.translator;

import emi.analysis.model.EMIConfiguration;
import emi.analysis.model.EMIFireableTransition;
import emi.analysis.model.EMIModel;
import emi.analysis.server.log.Log;
import emi.analysis.server.translator.EndiannessDetection;
import emi.analysis.server.translator.TranslatorException;
import emi.serializer.symbols.SymbolMatcher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.uml2.uml.Transition;

public final class Translator {
    public static final String DEFAULT_DWARF_TOOL = "pahole";
    private boolean log;
    private MetaECTreeItem metaECTreeRoot;
    private IMetaECTreeGenerator metaECTreeGenerator;
    private ITranslationBuilder translationBuilder;
    private SymbolMatcher symbolMatcher;

    public boolean hasLog() {
        return this.log;
    }

    Translator(String searchDir, String emiModel, IMetaECTreeGenerator metaECTreeGenerator, ITranslationBuilder translationBuilder, boolean log) throws IOException {
        this.log = log;
        this.metaECTreeGenerator = metaECTreeGenerator;
        this.translationBuilder = translationBuilder;
        this.symbolMatcher = new SymbolMatcher(emiModel, EMIModel.deduceModelName(emiModel));
        this.metaECTreeRoot = new MetaECTreeItem("Store", "store", 1, 0, 0, null);
        this.metaECTreeGenerator.generateMetaECTree(this.metaECTreeRoot);
        this.metaECTreeGenerator.close();
        this.metaECTreeRoot.computeParent(null);
        MetaECTreeItem.endianness = EndiannessDetection.detectEndianness(searchDir);
        MetaECTreeItem.symbolMatcher = this.symbolMatcher;
    }

    public String translate(EMIConfiguration configuration) throws TranslatorException {
        return this.translationBuilder.translate(configuration, this.metaECTreeRoot);
    }

    public String translate(EMIFireableTransition transition) throws TranslatorException {
        String ao = this.symbolMatcher.searchActiveObject(transition.getActiveObjectId());
        Transition tr = this.symbolMatcher.searchTransition(ao, transition.getActiveObjectCS(), transition.getTransitionId());
        return this.translationBuilder.translate(new MetaEFT(ao, tr.getName(), tr.getSource().getName(), tr.getTarget().getName()));
    }

    public void displayMetaECTree() {
        Log.d("Target endianness: " + MetaECTreeItem.endianness.getValue());
        if (this.metaECTreeRoot != null) {
            this.metaECTreeRoot.display(0, false, new boolean[0]);
        } else {
            Log.d("[MetaECTree] The meta EMI configuration tree is null (bug)");
        }
    }

    public static String createArrayItemName(String itemName, int index) {
        return itemName + "[" + index + "]";
    }

    public static boolean isPrimitiveType(String typeName) {
        return typeName != null && (typeName.startsWith("int") || typeName.startsWith("unsigned int") || typeName.startsWith("char") || typeName.startsWith("unsigned char") || typeName.startsWith("bool") || typeName.endsWith("_t"));
    }

    public static boolean isUnion(String typeName) {
        return typeName != null && typeName.startsWith("union");
    }

    public static boolean isUMLType(String typeName) {
        return typeName != null && typeName.startsWith("UML_");
    }

    public static interface ITranslationBuilder {
        public String translate(EMIConfiguration var1, MetaECTreeItem var2);

        public String translate(MetaEFT var1);
    }

    public static interface IMetaECTreeGenerator {
        public void generateMetaECTree(MetaECTreeItem var1) throws IOException;

        public void close() throws IOException;
    }

    public static class MetaEFT {
        private String activeObject;
        private String name;
        private String source;
        private String target;

        public MetaEFT(String activeObject, String name, String source, String target) {
            this.activeObject = activeObject;
            this.name = name;
            this.source = source;
            this.target = target;
        }

        public String getActiveObject() {
            return this.activeObject;
        }

        public String getName() {
            return this.name;
        }

        public String getSource() {
            return this.source;
        }

        public String getTarget() {
            return this.target;
        }

        public String toString() {
            return this.activeObject + ": " + this.source + " -[" + this.name + "]-> " + this.target;
        }
    }

    public static class MetaECTreeItem {
        private String type;
        private String name;
        private int nbElements;
        private int offset;
        private int size;
        private final List<MetaECTreeItem> children = new ArrayList<MetaECTreeItem>();
        private MetaECTreeItem parent;
        private static EndiannessDetection.Endianness endianness;
        private static SymbolMatcher symbolMatcher;

        public MetaECTreeItem(String type, String name, int nbElements, int offset, int size, List<MetaECTreeItem> children) {
            this.type = type;
            this.name = name;
            this.nbElements = nbElements;
            this.offset = offset;
            this.size = size;
            if (children != null) {
                this.children.addAll(children);
            }
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public int getNbElements() {
            return this.nbElements;
        }

        public void setNbElements(int nbElements) {
            this.nbElements = nbElements;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public List<MetaECTreeItem> getChildren() {
            return this.children;
        }

        public boolean isLeaf() {
            return this.children == null || this.children.size() == 0;
        }

        public String toString() {
            return this.type + " " + this.name + " (nb: " + this.nbElements + ", offset: " + this.offset + " size: " + this.size + " children: " + this.children.size() + ")";
        }

        public void display(int level, Boolean last, boolean[] connectParent) {
            StringBuffer indent = new StringBuffer();
            if (level > 0) {
                for (int i = 0; i < level - 1; ++i) {
                    indent.append(connectParent[i] ? " \u2502 " : "   ");
                }
                indent.append(last != false ? " \u2514\u2500 " : " \u251c\u2500 ");
            }
            Log.d("[MetaECTree] " + indent.toString() + this.toString());
            boolean[] cParent = new boolean[level + 1];
            for (int i = 0; i < connectParent.length; ++i) {
                cParent[i] = connectParent[i];
            }
            cParent[cParent.length - 1] = true;
            if (last.booleanValue()) {
                cParent[level - 1] = false;
            }
            int index = 0;
            for (MetaECTreeItem child : this.children) {
                child.display(level + 1, ++index == this.children.size(), cParent);
            }
        }

        public void computeParent(MetaECTreeItem parent) {
            this.parent = parent;
            for (MetaECTreeItem child : this.children) {
                child.computeParent(this);
            }
        }

        public String computeValue(EMIConfiguration configuration) {
            String value = null;
            switch (this.size) {
                case 1: {
                    value = Integer.toString(configuration.getData().get(this.offset));
                    break;
                }
                case 4: {
                    int intValue = configuration.getData().getInt(this.offset);
                    if (endianness == EndiannessDetection.Endianness.LITTLE_ENDIAN) {
                        intValue = Integer.reverseBytes(intValue);
                    }
                    value = Integer.toString(intValue);
                    break;
                }
                default: {
                    value = "***error***";
                }
            }
            if ("cs".equals(this.name) && this.parent != null && this.parent.getType().endsWith("_store")) {
                value = MetaECTreeItem.resolveCSName(this.parent.getName(), Integer.parseInt(value));
            }
            if ("signalEventId".equals(this.name) && this.parent != null && this.parent.getName().startsWith("eventOccurred")) {
                value = MetaECTreeItem.resolveSEName(Integer.parseInt(value));
            }
            return value;
        }

        private static String resolveCSName(String activeObject, int intValue) {
            return symbolMatcher.searchState(activeObject, intValue).getName();
        }

        private static String resolveSEName(int intValue) {
            if (intValue == -1) {
                return "(empty)";
            }
            return symbolMatcher.searchSignalEvent(intValue).getName();
        }
    }
}

