/*
 * Decompiled with CFR 0.152.
 */
package emi.analysis.protocol;

import emi.analysis.model.EMIFireableTransition;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public final class EMIProtocolFireableTransition {
    public static final int SIZEOF_TRANSITION_ID = 4;
    public static final int SIZEOF_ACTIVE_OBJECT_ID = 4;
    public static final int SIZEOF_ACTIVE_OBJECT_CS = 4;
    public static final int SIZEOF_FIREABLE_TRANSITION = 12;

    private EMIProtocolFireableTransition() {
    }

    public static ArrayList<EMIFireableTransition> deserialize(byte[] data) {
        ArrayList<EMIFireableTransition> fireableTransitions = new ArrayList<EMIFireableTransition>();
        int nb = data.length / 12;
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        for (int i = 0; i < nb; ++i) {
            int activeObjectId = byteBuffer.getInt();
            int activeObjectCS = byteBuffer.getInt();
            int transitionId = byteBuffer.getInt();
            fireableTransitions.add(new EMIFireableTransition(activeObjectId, activeObjectCS, transitionId));
        }
        return fireableTransitions;
    }

    public static byte[] serialize(EMIFireableTransition transition) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(12);
        byteBuffer.putInt(transition.getActiveObjectId());
        byteBuffer.putInt(transition.getActiveObjectCS());
        byteBuffer.putInt(transition.getTransitionId());
        return byteBuffer.array();
    }
}

