/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.memoryobjects;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import emi.serializer.model.PartClassifierInstance;
import emi.serializer.utils.UmlNavigation;
import emi.serializer.utils.UmlSerializerExtensions;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class Peers {
    private final List<PartClassifierInstance> parts;
    private final List<Association> associations;
    private final List<Connector> connectors;

    public Peers(Resource r) {
        this.parts = UmlNavigation.collectPartClassifierInstance(r);
        this.associations = IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)r.getAllContents(), Association.class));
        this.connectors = IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)r.getAllContents(), Connector.class));
    }

    public static String getPeersTypeName(Class e) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = e.getName();
        _builder.append(_name);
        _builder.append("_peers");
        return _builder.toString();
    }

    private Set<Property> getPeers(Class e) {
        HashSet<Property> _xblockexpression = null;
        HashSet<Property> peers = new HashSet<Property>();
        Functions.Function1 _function = it -> {
            Functions.Function1 _function_1 = it_1 -> {
                Type _type = it_1.getType();
                return (Class)_type;
            };
            return IterableExtensions.toList((Iterable)ListExtensions.map((List)it.getMemberEnds(), (Functions.Function1)_function_1)).contains(e);
        };
        List associations = IterableExtensions.toList((Iterable)IterableExtensions.filter(this.associations, (Functions.Function1)_function));
        Functions.Function1 _function_1 = it -> it.getMemberEnds();
        List allMemberEnd = IterableExtensions.toList((Iterable)ListExtensions.map((List)associations, (Functions.Function1)_function_1));
        Functions.Function1 _function_2 = it -> {
            Type _type = it.getType();
            boolean _equals = ((Class)_type).equals(e);
            return !_equals;
        };
        Iterable endPeers = IterableExtensions.filter((Iterable)Iterables.concat((Iterable)allMemberEnd), (Functions.Function1)_function_2);
        Functions.Function1 _function_3 = it -> it.isBehavior();
        Iterable behavioralPorts = IterableExtensions.filter((Iterable)e.getOwnedPorts(), (Functions.Function1)_function_3);
        Iterables.addAll(peers, (Iterable)endPeers);
        Iterables.addAll(peers, (Iterable)behavioralPorts);
        _xblockexpression = peers;
        return _xblockexpression;
    }

    public Set<Property> getAllPeers(Class e) {
        HashSet<Property> _xblockexpression = null;
        HashSet<Property> peers = new HashSet<Property>();
        peers.addAll(this.getPeers(e));
        Consumer<Classifier> _function = it -> peers.addAll(this.getPeers((Class)it));
        e.allParents().forEach(_function);
        _xblockexpression = peers;
        return _xblockexpression;
    }

    public int getNbPeers(Class e) {
        boolean _notEquals;
        Integer _xblockexpression = null;
        Set<Property> peers = this.getAllPeers(e);
        Integer _xifexpression = null;
        int _length = ((Object[])Conversions.unwrapArray(peers, Object.class)).length;
        boolean bl = _notEquals = _length != 0;
        if (_notEquals) {
            Functions.Function1 _function = it -> it.getLower();
            Functions.Function2 _function_1 = (p1, p2) -> p1 + p2;
            _xifexpression = (Integer)IterableExtensions.reduce((Iterable)IterableExtensions.map(peers, (Functions.Function1)_function), (Functions.Function2)_function_1);
        } else {
            _xifexpression = 0;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private Property getPeerPart(Property memberEnd, Property part) {
        Property _xblockexpression = null;
        Property peerPart = null;
        Type _type = part.getType();
        Functions.Function1 _function = it -> it.isBehavior();
        List ports = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)((Class)_type).getOwnedPorts(), (Functions.Function1)_function));
        boolean _contains = ports.contains(memberEnd);
        if (_contains) {
            peerPart = memberEnd;
        } else {
            Association association = memberEnd.getAssociation();
            Functions.Function1 _function_1 = it -> {
                Association _type_1 = it.getType();
                return Objects.equal((Object)_type_1, (Object)association);
            };
            List connectors = IterableExtensions.toList((Iterable)IterableExtensions.filter(this.connectors, (Functions.Function1)_function_1));
            Functions.Function1 _function_2 = it -> {
                Functions.Function1 _function_3 = it_1 -> {
                    ConnectableElement _role = it_1.getRole();
                    return !Objects.equal((Object)_role, (Object)part);
                };
                return IterableExtensions.filter((Iterable)it.getEnds(), (Functions.Function1)_function_3);
            };
            ConnectorEnd end = (ConnectorEnd)IterableExtensions.head((Iterable)Iterables.concat((Iterable)IterableExtensions.toList((Iterable)ListExtensions.map((List)connectors, (Functions.Function1)_function_2))));
            ConnectableElement _role = end.getRole();
            peerPart = (Property)_role;
        }
        _xblockexpression = peerPart;
        return _xblockexpression;
    }

    private PartClassifierInstance matchPeerObject(Property part, List<PartClassifierInstance> partsObjects) {
        Functions.Function1 _function = it -> {
            Property _part = it.getPart();
            return Objects.equal((Object)_part, (Object)part);
        };
        return (PartClassifierInstance)IterableExtensions.head((Iterable)IterableExtensions.filter(partsObjects, (Functions.Function1)_function));
    }

    private String typedefToC(Class e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("typedef struct ");
        String _name = e.getName();
        _builder.append(_name);
        _builder.append("_peers ");
        String _name_1 = e.getName();
        _builder.append(_name_1);
        _builder.append("_peers;");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private String typeToC(Class e) {
        String _xblockexpression = null;
        Set<Property> peers = this.getPeers(e);
        EList superClasses = e.getSuperClasses();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* The ");
        String _name = e.getName();
        _builder.append(_name, " ");
        _builder.append("_peers type used to link instances of the ");
        String _name_1 = e.getName();
        _builder.append(_name_1, " ");
        _builder.append(" class with their peers.");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("struct ");
        String _name_2 = e.getName();
        _builder.append(_name_2);
        _builder.append("_peers {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        Functions.Function1 _function = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("ABSTRACT_");
            String _upperCase = it.getName().toUpperCase();
            _builder_1.append(_upperCase);
            _builder_1.append("_PEERS");
            return _builder_1.toString();
        };
        String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)superClasses, (Functions.Function1)_function), (CharSequence)"\n");
        _builder.append(_join, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        Functions.Function1 _function_1 = it -> this.subfieldTypeToC((Property)it);
        String _join_1 = IterableExtensions.join((Iterable)IterableExtensions.map(peers, (Functions.Function1)_function_1), (CharSequence)"\n");
        _builder.append(_join_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private String abstractPeersToC(Class e) {
        boolean _notEquals;
        String _xblockexpression = null;
        Set<Property> peers = this.getPeers(e);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#define ABSTRACT_");
        String _upperCase = e.getName().toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_PEERS ");
        StringConcatenation _xifexpression = null;
        Set<Property> _converted_peers = peers;
        int _length = ((Object[])Conversions.unwrapArray(_converted_peers, Object.class)).length;
        boolean bl = _notEquals = _length != 0;
        if (_notEquals) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("\\");
            _xifexpression = _builder_1;
        }
        _builder.append(_xifexpression);
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        Functions.Function1 _function = it -> this.subfieldTypeToC((Property)it);
        String _join = IterableExtensions.join((Iterable)IterableExtensions.map(peers, (Functions.Function1)_function), (CharSequence)" \\\n");
        _builder.append(_join, "\t");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private String subfieldTypeToC(Property e) {
        boolean _equals;
        StringConcatenation _builder = new StringConcatenation();
        Object _xifexpression = null;
        int _lower = e.getLower();
        boolean bl = _equals = _lower == 1;
        if (_equals) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Object * ");
            String _name = e.getName();
            _builder_1.append(_name);
            _builder_1.append(";");
            _xifexpression = _builder_1;
        } else {
            int _lower_1 = e.getLower();
            int _minus = _lower_1 - 1;
            Functions.Function1 _function = it -> {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("Object * ");
                String _name_1 = e.getName();
                _builder_2.append(_name_1);
                _builder_2.append("_");
                _builder_2.append(it);
                _builder_2.append(";");
                return _builder_2.toString();
            };
            _xifexpression = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)new IntegerRange(0, _minus), (Functions.Function1)_function), (CharSequence)"\n");
        }
        _builder.append(_xifexpression);
        return _builder.toString();
    }

    private String fieldTypeToC(PartClassifierInstance e) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = e.getClassifier().getName();
        _builder.append(_name);
        _builder.append("_peers ");
        String _name_1 = e.getPart().getName();
        _builder.append(_name_1);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private String fieldToC(PartClassifierInstance e, List<PartClassifierInstance> partsObjects) {
        String _xblockexpression = null;
        Classifier _classifier = e.getClassifier();
        Class type = (Class)_classifier;
        Set<Property> peers = this.getAllPeers(type);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(".");
        String _name = e.getPart().getName();
        _builder.append(_name);
        _builder.append(" = {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        Functions.Function1 _function = it -> {
            String _xblockexpression_1 = null;
            Property peerPart = this.getPeerPart((Property)it, e.getPart());
            _xblockexpression_1 = this.subfieldToC((Property)it, this.matchPeerObject(peerPart, partsObjects));
            return _xblockexpression_1;
        };
        String _join = IterableExtensions.join((Iterable)IterableExtensions.map(peers, (Functions.Function1)_function), (CharSequence)",\n");
        _builder.append(_join, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private String subfieldToC(Property peer, PartClassifierInstance e) {
        boolean _equals;
        String _xblockexpression = null;
        Classifier _classifier = e.getClassifier();
        String objectType = this.getObjectTypePrefix((Class)_classifier);
        StringConcatenation _builder = new StringConcatenation();
        String _xifexpression = null;
        int _lower = peer.getLower();
        boolean bl = _equals = _lower == 1;
        if (_equals) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append(".");
            String _name = peer.getName();
            _builder_1.append(_name);
            _builder_1.append(" = (Object *) &");
            _builder_1.append(objectType);
            _builder_1.append("_");
            String _actualName = UmlSerializerExtensions.actualName((EObject)e.getPart());
            _builder_1.append(_actualName);
            _xifexpression = _builder_1;
        } else {
            int _lower_1 = peer.getLower();
            int _minus = _lower_1 - 1;
            Functions.Function1 _function = it -> {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append(".");
                String _name_1 = peer.getName();
                _builder_2.append(_name_1);
                _builder_2.append("_");
                _builder_2.append(it);
                _builder_2.append(" = (Object *) &");
                _builder_2.append(objectType);
                _builder_2.append("_");
                String _actualName_1 = UmlSerializerExtensions.actualName((EObject)e.getPart());
                _builder_2.append(_actualName_1);
                _builder_2.append("_");
                _builder_2.append(it);
                return _builder_2.toString();
            };
            _xifexpression = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)new IntegerRange(0, _minus), (Functions.Function1)_function), (CharSequence)",\n");
        }
        _builder.append((Object)_xifexpression);
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private String getObjectTypePrefix(Class e) {
        String _xifexpression = null;
        boolean _isActive = e.isActive();
        _xifexpression = _isActive ? "ao" : "po";
        return _xifexpression;
    }

    public String serializeHeaders() {
        String _xblockexpression = null;
        Functions.Function1 _function = it -> it.getClassifier().allParents();
        Set superClasses = IterableExtensions.toSet((Iterable)Iterables.filter((Iterable)Iterables.concat((Iterable)ListExtensions.map(this.parts, (Functions.Function1)_function)), Class.class));
        HashSet classes = new HashSet();
        classes.addAll(superClasses);
        Functions.Function1 _function_1 = it -> {
            Classifier _classifier = it.getClassifier();
            return (Class)_classifier;
        };
        classes.addAll(ListExtensions.map(this.parts, (Functions.Function1)_function_1));
        IterableExtensions.toSet(classes);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Declaration of peers types for superclasses.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        Functions.Function1 _function_2 = it -> this.abstractPeersToC((Class)it);
        String _join = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)superClasses, (Functions.Function1)_function_2));
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Declaration of peers types for classes.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        Functions.Function1 _function_3 = it -> this.typedefToC((Class)it);
        String _join_1 = IterableExtensions.join((Iterable)IterableExtensions.map(classes, (Functions.Function1)_function_3));
        _builder.append(_join_1);
        _builder.newLineIfNotEmpty();
        _builder.append("typedef struct Peers Peers;");
        _builder.newLine();
        Functions.Function1 _function_4 = it -> this.typeToC((Class)it);
        String _join_2 = IterableExtensions.join((Iterable)IterableExtensions.map(classes, (Functions.Function1)_function_4));
        _builder.append(_join_2);
        _builder.newLineIfNotEmpty();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* The global Peers type used to make links between active objects.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("struct Peers {");
        _builder.newLine();
        _builder.append("\t");
        Functions.Function1 _function_5 = it -> this.fieldTypeToC((PartClassifierInstance)it);
        String _join_3 = IterableExtensions.join((Iterable)ListExtensions.map(this.parts, (Functions.Function1)_function_5));
        _builder.append(_join_3, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        _builder.append("extern Peers peers;");
        _builder.newLine();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    public String serialize() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Struct initializer for Peers.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("Peers peers = {");
        _builder.newLine();
        _builder.append("\t");
        Functions.Function1 _function = it -> this.fieldToC((PartClassifierInstance)it, this.parts);
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(this.parts, (Functions.Function1)_function), (CharSequence)",\n");
        _builder.append(_join, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        return _builder.toString();
    }
}

