/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.actionlanguage.C;

import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import emi.serializer.actionlanguage.C.MatcherC;
import emi.serializer.actionlanguage.C.MatchingUnitC;
import emi.serializer.actionlanguage.C.RegexGroupKindC;
import emi.serializer.actionlanguage.C.RegexKindC;
import emi.serializer.actionlanguage.C.SymbolException;
import emi.serializer.diagram.Diagram;
import emi.serializer.diagram.DiagramAttributeUnit;
import emi.serializer.model.PartClassifierInstance;
import emi.serializer.symbols.SymbolClass;
import emi.serializer.symbols.SymbolTable;
import emi.serializer.utils.UmlNavigation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class ConvertorC {
    private final SymbolTable symbolTable;
    private final List<PartClassifierInstance> parts;
    private final List<SignalEvent> signalEvents;
    private String sInit;
    private final MatcherC matcher;

    public ConvertorC(SymbolTable symbolTable, Resource r) {
        MatcherC _matcherC;
        String _string;
        this.symbolTable = symbolTable;
        this.signalEvents = IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)r.getAllContents(), SignalEvent.class));
        this.parts = UmlNavigation.collectPartClassifierInstance(r);
        this.sInit = _string = new String();
        this.matcher = _matcherC = new MatcherC();
    }

    public String convertAll(List<MatchingUnitC> units, Class c, boolean withDiagram) {
        String _xblockexpression = null;
        Diagram diagram = new Diagram();
        String s = new String();
        try {
            for (MatchingUnitC unit : units) {
                RegexKindC _kind = unit.getKind();
                if (_kind == null) continue;
                switch (_kind) {
                    case REGEX_ATTRIBUTE_ACCESS: {
                        s = s.concat(this.convertAttributeAccess(unit.getString(), c, diagram));
                        break;
                    }
                    case REGEX_SEND: {
                        s = s.concat(this.convertSignalSending(unit, c, diagram));
                        break;
                    }
                    case REGEX_SEND_PEERS: {
                        s = s.concat(this.convertSignalSendingToAllPeers(unit, c, diagram));
                        break;
                    }
                    case REGEX_EP_GET_FIRST: {
                        s = s.concat(this.convertEventPoolMethods(unit, c, diagram));
                        break;
                    }
                    case REGEX_EP_GET_LAST: {
                        s = s.concat(this.convertEventPoolMethods(unit, c, diagram));
                        break;
                    }
                    case REGEX_EP_GET_AT: {
                        s = s.concat(this.convertEventPoolMethods(unit, c, diagram));
                        break;
                    }
                    case REGEX_EP_CONTAINS: {
                        s = s.concat(this.convertEventPoolMethods(unit, c, diagram));
                        break;
                    }
                    case REGEX_EP_IS_FULL: {
                        s = s.concat(this.convertEventPoolMethods(unit, c, diagram));
                        break;
                    }
                    case REGEX_EP_IS_EMPTY: {
                        s = s.concat(this.convertEventPoolMethods(unit, c, diagram));
                        break;
                    }
                    case REGEX_STATE_NAME: {
                        s = s.concat(unit.getString());
                        break;
                    }
                    case REGEX_NO_MATCH: {
                        s = s.concat(unit.getString());
                        break;
                    }
                }
            }
        }
        catch (Throwable _t) {
            if (_t instanceof SymbolException) {
                String _string;
                SymbolException e = (SymbolException)_t;
                String _message = e.getMessage();
                String _plus = "// " + _message;
                s = _string = new String(_plus);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        if (withDiagram) {
            StringConcatenation _builder = new StringConcatenation();
            String _addMessagesBefore = diagram.addMessagesBefore();
            _builder.append(_addMessagesBefore);
            _builder.newLineIfNotEmpty();
            _builder.append(s);
            _builder.newLineIfNotEmpty();
            String _addMessagesAfter = diagram.addMessagesAfter();
            _builder.append(_addMessagesAfter);
            _builder.newLineIfNotEmpty();
            s = _builder.toString();
        }
        _xblockexpression = s;
        return _xblockexpression;
    }

    private String convertAttributeAccess(String s, Class c, Diagram diagram) throws SymbolException {
        String _xblockexpression = null;
        String sReplace = null;
        String currentClass = null;
        String aoSource = null;
        String aoDest = null;
        SymbolClass symbolClass = null;
        String[] groups = s.replaceAll("\\p{Space}", "").split("[.]");
        int indexGroups = 0;
        Pair<String, String> pair = this.getPartName(groups[0]);
        String partName = (String)pair.getKey();
        String runtimePartName = (String)pair.getValue();
        if (c != null) {
            String _string_1;
            String _string;
            sReplace = _string = new String("ao");
            currentClass = c.getName();
            symbolClass = this.symbolTable.getSymbolClasses().get(currentClass);
            if (currentClass != null && symbolClass != null && (groups.length == 1 && !symbolClass.getPrimitiveAttributes().contains(partName) || groups.length > 1 && !ListExtensions.map(symbolClass.getPeers(), it -> it.getName()).contains(partName))) {
                return s;
            }
            aoSource = _string_1 = new String("ao");
        } else {
            String _string_2;
            ++indexGroups;
            sReplace = this.getObjectTypePrefix(partName).concat(runtimePartName);
            currentClass = this.symbolTable.getFlatMapping().get(runtimePartName);
            if (currentClass == null || this.symbolTable.getSymbolClasses().get(currentClass) == null) {
                return s;
            }
            aoSource = _string_2 = new String(runtimePartName);
        }
        aoDest = aoSource;
        for (int i = indexGroups; i < groups.length - 1; ++i) {
            Pair<String, String> peerPair = this.getPartName(groups[i]);
            String peerName = (String)peerPair.getKey();
            String runtimePeerName = (String)peerPair.getValue();
            symbolClass = this.symbolTable.getSymbolClasses().get(currentClass);
            if (currentClass == null || symbolClass == null || !ListExtensions.map(symbolClass.getPeers(), it -> it.getName()).contains(peerName)) {
                throw new SymbolException("ERROR[peer access]: class " + currentClass + " has no peer named " + peerName);
            }
            sReplace = "((" + currentClass + "_peers*) " + sReplace + "->peers)->" + runtimePeerName;
            Functions.Function1 _function = it -> {
                String _name = it.getName();
                return Objects.equal((Object)_name, (Object)peerName);
            };
            currentClass = ((Property)IterableExtensions.head((Iterable)IterableExtensions.filter(symbolClass.getPeers(), (Functions.Function1)_function))).getType().getName();
            aoDest = runtimePeerName;
        }
        int _length = groups.length;
        int _minus = _length - 1;
        String attribute = groups[_minus];
        boolean _equals = attribute.equals("state");
        if (_equals) {
            sReplace = "*(" + sReplace + "->store_cs)";
        } else {
            symbolClass = this.symbolTable.getSymbolClasses().get(currentClass);
            if (currentClass == null || symbolClass == null || !symbolClass.getPrimitiveAttributes().contains(attribute)) {
                throw new SymbolException("ERROR[attribute access]: class " + currentClass + " has no attribute named \"" + attribute + "\"");
            }
            sReplace = "((" + currentClass + "_store*) " + sReplace + "->store)->od." + attribute;
        }
        DiagramAttributeUnit attributeUnit = new DiagramAttributeUnit(aoSource, aoDest, attribute, sReplace);
        diagram.addAttributeUnit(attributeUnit);
        _xblockexpression = sReplace;
        return _xblockexpression;
    }

    private String convertSignalSending(MatchingUnitC unit, Class c, Diagram diagram) {
        String sReplace;
        String _xblockexpression = null;
        String currentClass = null;
        SymbolClass symbolClass = null;
        String sReceiverReplace = null;
        int indexGroups = 0;
        String aoSource = null;
        String aoDest = null;
        String strReceiver = unit.getGroups().get(RegexGroupKindC.RGK_SEND_PEER.getId());
        String[] groups = strReceiver.split("[.]");
        if (c != null) {
            String _string_1;
            String _string;
            sReceiverReplace = _string = new String("ao");
            currentClass = c.getName();
            aoSource = _string_1 = new String("ao");
        } else {
            Pair<String, String> pair = this.getPartName(groups[0]);
            String partName = (String)pair.getKey();
            String runtimePartName = (String)pair.getValue();
            sReceiverReplace = this.getObjectTypePrefix(partName).concat(runtimePartName);
            currentClass = this.symbolTable.getFlatMapping().get(runtimePartName);
            ++indexGroups;
            aoSource = runtimePartName;
        }
        for (int i = indexGroups; i < groups.length; ++i) {
            Pair<String, String> peerPair = this.getPartName(groups[i]);
            String peerName = (String)peerPair.getKey();
            String runtimePeerName = (String)peerPair.getValue();
            symbolClass = this.symbolTable.getSymbolClasses().get(currentClass);
            if (currentClass == null || symbolClass == null || !ListExtensions.map(symbolClass.getPeers(), it -> it.getName()).contains(peerName)) {
                throw new SymbolException("ERROR[peer access]: class " + currentClass + " has no peer named " + peerName);
            }
            sReceiverReplace = "((" + currentClass + "_peers*) " + sReceiverReplace + "->peers)->" + runtimePeerName;
            Functions.Function1 _function = it -> {
                String _name = it.getName();
                return Objects.equal((Object)_name, (Object)peerName);
            };
            currentClass = ((Property)IterableExtensions.head((Iterable)IterableExtensions.filter(symbolClass.getPeers(), (Functions.Function1)_function))).getType().getName();
            aoDest = runtimePeerName;
        }
        ArrayList<String> parameters = new ArrayList<String>();
        String strParameters = unit.getGroups().get(RegexGroupKindC.RGK_SEND_SIGNAL_PARAMS.getId());
        if (((Object[])Conversions.unwrapArray(unit.getGroups(), Object.class)).length >= RegexGroupKindC.RGK_SEND_SIGNAL_PARAMS.getId() && strParameters != null) {
            parameters.addAll(this.getEventParameters(strParameters, c, diagram));
        }
        String hash = Integer.toString(unit.getString().hashCode()).replaceAll("-", "__MINUS__");
        String signalName = unit.getGroups().get(RegexGroupKindC.RGK_SEND_SIGNAL_NAME.getId());
        SignalEvent signalEvent = this.symbolTable.getSymbolEvents().get(signalName);
        String signalParamsTypeName = signalName + "_signal_parameters";
        if (signalEvent == null) {
            throw new SymbolException("ERROR[signal sending]: no signal event found for signal " + signalName);
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("EventMetaData analysis_");
        _builder.append(hash);
        _builder.append(" = {0};");
        _builder.newLineIfNotEmpty();
        _builder.append("#ifdef WITH_TRACE");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("analysis_");
        _builder.append(hash, "\t");
        _builder.append(" = (EventMetaData) {.timestamp = __timestamp, .sender = ao->name};");
        _builder.newLineIfNotEmpty();
        _builder.append("#endif");
        _builder.newLine();
        StringConcatenation _xifexpression = null;
        boolean _isEmpty = parameters.isEmpty();
        if (_isEmpty) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Object_processEvent((Object *) ");
            _builder_1.append(sReceiverReplace);
            _builder_1.append(", signalEvents.");
            String _name = signalEvent.getName();
            _builder_1.append(_name);
            _builder_1.append(", NULL, 0,  &analysis_");
            _builder_1.append(hash);
            _builder_1.append(");");
            _xifexpression = _builder_1;
        } else {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append(signalParamsTypeName);
            _builder_2.append(" ev_params_");
            _builder_2.append(hash);
            _builder_2.append(" = {");
            _builder_2.newLineIfNotEmpty();
            _builder_2.append("\t");
            String _join = IterableExtensions.join(parameters, (CharSequence)",\n");
            _builder_2.append(_join, "\t");
            _builder_2.newLineIfNotEmpty();
            _builder_2.append("};");
            _builder_2.newLine();
            _builder_2.append("Object_processEvent((Object *) ");
            _builder_2.append(sReceiverReplace);
            _builder_2.append(", signalEvents.");
            String _name_1 = signalEvent.getName();
            _builder_2.append(_name_1);
            _builder_2.append(", &ev_params_");
            _builder_2.append(hash);
            _builder_2.append(", sizeof(");
            _builder_2.append(signalParamsTypeName);
            _builder_2.append("), &analysis_");
            _builder_2.append(hash);
            _builder_2.append(");");
            _xifexpression = _builder_2;
        }
        _builder.append((Object)_xifexpression);
        _xblockexpression = sReplace = _builder.toString();
        return _xblockexpression;
    }

    private String convertSignalSendingToAllPeers(MatchingUnitC unit, Class c, Diagram diagram) {
        String sReplace;
        String _xblockexpression = null;
        String currentClass = c.getName();
        List<String> peers = this.getActivePeersName(currentClass);
        ArrayList<String> parameters = new ArrayList<String>();
        String strParameters = unit.getGroups().get(RegexGroupKindC.RGK_SEND_SIGNAL_PARAMS.getId());
        if (((Object[])Conversions.unwrapArray(unit.getGroups(), Object.class)).length >= RegexGroupKindC.RGK_SEND_SIGNAL_PARAMS.getId() && strParameters != null) {
            parameters.addAll(this.getEventParameters(strParameters, c, diagram));
        }
        String hash = Integer.toString(unit.getString().hashCode()).replaceAll("-", "__MINUS__");
        String signalName = unit.getGroups().get(RegexGroupKindC.RGK_SEND_SIGNAL_NAME.getId());
        SignalEvent signalEvent = this.symbolTable.getSymbolEvents().get(signalName);
        String signalParamsTypeName = signalName + "_signal_parameters";
        if (signalEvent == null) {
            String _get = unit.getGroups().get(0);
            String _plus = "ERROR[signal sending]: no signal event found for signal " + _get;
            throw new SymbolException(_plus);
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("EventMetaData analysis_");
        _builder.append(hash);
        _builder.append(" = {0};");
        _builder.newLineIfNotEmpty();
        _builder.append("#ifdef WITH_TRACE");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("analysis_");
        _builder.append(hash, "\t");
        _builder.append(" = (EventMetaData) {.timestamp = __timestamp, .sender = ao->name};");
        _builder.newLineIfNotEmpty();
        _builder.append("#endif");
        _builder.newLine();
        StringConcatenation _xifexpression = null;
        boolean _isEmpty = parameters.isEmpty();
        if (_isEmpty) {
            StringConcatenation _builder_1 = new StringConcatenation();
            for (String peer : peers) {
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("Object_processEvent((Object *) (( ");
                _builder_1.append(currentClass);
                _builder_1.append("_peers*) ao->peers)->");
                _builder_1.append(peer);
                _builder_1.append(" , signalEvents.");
                String _name = signalEvent.getName();
                _builder_1.append(_name);
                _builder_1.append(", NULL, 0, &analysis_");
                _builder_1.append(hash);
                _builder_1.append(");");
                _builder_1.newLineIfNotEmpty();
            }
            _xifexpression = _builder_1;
        } else {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append(signalParamsTypeName);
            _builder_2.append(" ev_params_");
            _builder_2.append(hash);
            _builder_2.append(" = {");
            _builder_2.newLineIfNotEmpty();
            _builder_2.append("\t");
            String _join = IterableExtensions.join(parameters, (CharSequence)",\n");
            _builder_2.append(_join, "\t");
            _builder_2.newLineIfNotEmpty();
            _builder_2.append("};");
            _builder_2.newLine();
            for (String peer_1 : peers) {
                _builder_2.append("Object_processEvent((Object *) (( ");
                _builder_2.append(currentClass);
                _builder_2.append("_peers*) ao->peers)->");
                _builder_2.append(peer_1);
                _builder_2.append(", signalEvents.");
                String _name_1 = signalEvent.getName();
                _builder_2.append(_name_1);
                _builder_2.append(", &ev_params_");
                _builder_2.append(hash);
                _builder_2.append(", sizeof(");
                _builder_2.append(signalParamsTypeName);
                _builder_2.append("), &analysis_");
                _builder_2.append(hash);
                _builder_2.append(");");
                _builder_2.newLineIfNotEmpty();
            }
            _xifexpression = _builder_2;
        }
        _builder.append((Object)_xifexpression);
        _xblockexpression = sReplace = _builder.toString();
        return _xblockexpression;
    }

    private String convertEventPoolMethods(MatchingUnitC unit, Class c, Diagram diagram) {
        String _xblockexpression = null;
        String currentClass = null;
        SymbolClass symbolClass = null;
        String strReceiver = unit.getGroups().get(RegexGroupKindC.RGK_EP_PEER.getId());
        String[] groups = strReceiver.split("[.]");
        String sReceiverReplace = null;
        int indexGroups = 0;
        if (c != null) {
            String _string;
            sReceiverReplace = _string = new String("ao");
            currentClass = c.getName();
        } else {
            Pair<String, String> pair = this.getPartName(groups[0]);
            String partName = (String)pair.getKey();
            String runtimePartName = (String)pair.getValue();
            sReceiverReplace = this.getObjectTypePrefix(partName).concat(runtimePartName);
            currentClass = this.symbolTable.getFlatMapping().get(runtimePartName);
            ++indexGroups;
        }
        for (int i = indexGroups; i < groups.length - 1; ++i) {
            Pair<String, String> peerPair = this.getPartName(groups[i]);
            String peerName = (String)peerPair.getKey();
            String runtimePeerName = (String)peerPair.getValue();
            symbolClass = this.symbolTable.getSymbolClasses().get(currentClass);
            if (currentClass == null || symbolClass == null || !ListExtensions.map(symbolClass.getPeers(), it -> it.getName()).contains(peerName)) {
                throw new SymbolException("ERROR[peer access]: class " + currentClass + " has no peer named " + peerName);
            }
            sReceiverReplace = "((" + currentClass + "_peers*) " + sReceiverReplace + "->peers)->" + runtimePeerName;
            Functions.Function1 _function = it -> {
                String _name = it.getName();
                return Objects.equal((Object)_name, (Object)peerName);
            };
            currentClass = ((Property)IterableExtensions.head((Iterable)IterableExtensions.filter(symbolClass.getPeers(), (Functions.Function1)_function))).getType().getName();
        }
        int _length = groups.length;
        int _minus = _length - 1;
        String lastGroup = groups[_minus];
        if (currentClass == null || this.symbolTable.getSymbolClasses().get(currentClass) == null || !lastGroup.equals("event_pool")) {
            throw new SymbolException("ERROR[event_pool access]: unexpected input \"" + lastGroup + "\" instead of event_pool");
        }
        sReceiverReplace = "((ActiveObject *) " + sReceiverReplace + ")->eventPool";
        ArrayList<String> parameters = new ArrayList<String>();
        String sReplaceParameters = new String("");
        String signalParamsTypeName = new String("");
        String hash = new String("");
        RegexKindC _kind = unit.getKind();
        boolean _equals = Objects.equal((Object)((Object)_kind), (Object)((Object)RegexKindC.REGEX_EP_CONTAINS));
        if (_equals) {
            boolean _not;
            String strParameters = unit.getGroups().get(RegexGroupKindC.RGK_EP_SIGNAL_PARAMS.getId());
            if (((Object[])Conversions.unwrapArray(unit.getGroups(), Object.class)).length >= RegexGroupKindC.RGK_EP_SIGNAL_PARAMS.getId() && strParameters != null) {
                parameters.addAll(this.getEventParameters(strParameters, c, diagram));
            }
            hash = Integer.toString(unit.getString().hashCode()).replaceAll("-", "__MINUS__");
            String signalName = unit.getGroups().get(RegexGroupKindC.RGK_EP_SIGNAL_NAME.getId());
            signalParamsTypeName = signalName + "_signal_parameters";
            StringConcatenation _builder = new StringConcatenation();
            boolean _isEmpty = parameters.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                _builder.newLineIfNotEmpty();
                _builder.append("&((");
                _builder.append(signalParamsTypeName);
                _builder.append(") {");
                String _join = IterableExtensions.join(parameters, (CharSequence)", ");
                _builder.append(_join);
                _builder.append("})");
                _builder.newLineIfNotEmpty();
            }
            sReplaceParameters = _builder.toString();
            this.sInit = this.sInit + sReplaceParameters;
        }
        String sReplace = new String();
        RegexKindC _kind_1 = unit.getKind();
        boolean _equals_1 = Objects.equal((Object)((Object)_kind_1), (Object)((Object)RegexKindC.REGEX_EP_GET_AT));
        if (_equals_1) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("EventPool_");
            String _keyword = unit.getKind().getKeyword();
            _builder_1.append(_keyword);
            _builder_1.append("(");
            _builder_1.append(sReceiverReplace);
            _builder_1.append(", ");
            String _get = unit.getGroups().get(RegexGroupKindC.RGK_EP_INDEX.getId());
            _builder_1.append(_get);
            _builder_1.append(")");
            sReplace = _builder_1.toString();
        } else {
            RegexKindC _kind_2 = unit.getKind();
            boolean _equals_2 = Objects.equal((Object)((Object)_kind_2), (Object)((Object)RegexKindC.REGEX_EP_CONTAINS));
            if (_equals_2) {
                String signalName_1 = unit.getGroups().get(1);
                SignalEvent signalEvent = this.symbolTable.getSymbolEvents().get(signalName_1);
                boolean _isEmpty_1 = parameters.isEmpty();
                if (_isEmpty_1) {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("EventPool_");
                    String _keyword_1 = unit.getKind().getKeyword();
                    _builder_2.append(_keyword_1);
                    _builder_2.append("(");
                    _builder_2.append(sReceiverReplace);
                    _builder_2.append(", signalEvents.");
                    String _name = signalEvent.getName();
                    _builder_2.append(_name);
                    _builder_2.append(", NULL, 0)");
                    sReplace = _builder_2.toString();
                } else {
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append("EventPool_");
                    String _keyword_2 = unit.getKind().getKeyword();
                    _builder_3.append(_keyword_2);
                    _builder_3.append("(");
                    _builder_3.append(sReceiverReplace);
                    _builder_3.append(", signalEvents.");
                    String _name_1 = signalEvent.getName();
                    _builder_3.append(_name_1);
                    _builder_3.append(", ");
                    _builder_3.append(sReplaceParameters);
                    _builder_3.append(", sizeof(");
                    _builder_3.append(signalParamsTypeName);
                    _builder_3.append("))");
                    sReplace = _builder_3.toString();
                }
            } else {
                StringConcatenation _builder_4 = new StringConcatenation();
                _builder_4.append("EventPool_");
                String _keyword_3 = unit.getKind().getKeyword();
                _builder_4.append(_keyword_3);
                _builder_4.append("(");
                _builder_4.append(sReceiverReplace);
                _builder_4.append(")");
                sReplace = _builder_4.toString();
            }
        }
        _xblockexpression = sReplace;
        return _xblockexpression;
    }

    private String getObjectTypePrefix(String name) {
        String _xifexpression = null;
        Functions.Function1 _function = it -> {
            Classifier _classifier = it.getClassifier();
            return ((Class)_classifier).isActive();
        };
        Functions.Function1 _function_1 = it -> it.getPart().getName();
        boolean _contains = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(this.parts, (Functions.Function1)_function), (Functions.Function1)_function_1)).contains(name);
        _xifexpression = _contains ? new String("activeObjects.") : new String("passiveObjects.");
        return _xifexpression;
    }

    private List<String> getActivePeersName(String className) {
        ArrayList<String> _xblockexpression = null;
        List<Property> peers = this.symbolTable.getSymbolClasses().get(className).getPeers();
        ArrayList<String> peersName = new ArrayList<String>();
        Consumer<Property> _function = it -> {
            boolean _equals;
            String name = it.getName();
            int _lower = it.getLower();
            boolean bl = _equals = _lower == 1;
            if (_equals) {
                peersName.add(name);
            } else {
                int _lower_1 = it.getLower();
                int _minus = _lower_1 - 1;
                Consumer<Integer> _function_1 = it_1 -> peersName.add(name + "_" + it_1);
                new IntegerRange(0, _minus).forEach(_function_1);
            }
        };
        peers.forEach(_function);
        _xblockexpression = peersName;
        return _xblockexpression;
    }

    private Pair<String, String> getPartName(String s) {
        boolean _tripleNotEquals;
        Pair _xblockexpression = null;
        List<String> groups = this.matcher.oneMatch(s, "([\\p{Alpha}_]+)(?:\\s)?(?:\\[(?:\\s)?((\\d+))(?:\\s)?\\])?");
        String name = groups.get(1);
        String suffixe = new String("");
        String _get = groups.get(2);
        boolean bl = _tripleNotEquals = _get != null;
        if (_tripleNotEquals) {
            String _plus;
            String _get_1 = groups.get(2);
            suffixe = _plus = "_" + _get_1;
        }
        _xblockexpression = new Pair((Object)name, (Object)(name + suffixe));
        return _xblockexpression;
    }

    private List<String> getEventParameters(String s, Class c, Diagram diagram) {
        List _xblockexpression = null;
        String[] groups = s.split(",");
        String[] params = new String[groups.length];
        for (int i = 0; i < groups.length; ++i) {
            String _string;
            List<MatchingUnitC> units = this.matcher.match(groups[i], RegexKindC.REGEX_ATTRIBUTE_ACCESS);
            params[i] = _string = new String("");
            for (MatchingUnitC unit : units) {
                RegexKindC _kind = unit.getKind();
                boolean _equals = Objects.equal((Object)((Object)_kind), (Object)((Object)RegexKindC.REGEX_ATTRIBUTE_ACCESS));
                if (_equals) {
                    params[i] = params[i].concat(this.convertAttributeAccess(unit.getString(), c, diagram));
                    continue;
                }
                params[i] = params[i].concat(unit.getString());
            }
        }
        _xblockexpression = IterableExtensions.toList((Iterable)((Iterable)Conversions.doWrapArray((Object)params)));
        return _xblockexpression;
    }
}

