/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.actionlanguage.C;

import com.google.common.collect.Iterators;
import emi.serializer.actionlanguage.C.ConvertorC;
import emi.serializer.actionlanguage.C.MatcherC;
import emi.serializer.actionlanguage.C.MatchingUnitC;
import emi.serializer.symbols.SymbolTable;
import emi.serializer.utils.UmlSerializerExtensions;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class ActionLanguageC {
    public static final String C_LANGUAGE_NAME = "C";
    private final MatcherC matcher;
    private final ConvertorC convertor;
    private final List<OpaqueExpression> opaqueExpressions;
    private final List<OpaqueBehavior> opaqueBehaviors;

    public ActionLanguageC(Resource r) {
        ConvertorC _convertorC;
        MatcherC _matcherC;
        this.matcher = _matcherC = new MatcherC();
        SymbolTable symbolTable = new SymbolTable(r);
        this.convertor = _convertorC = new ConvertorC(symbolTable, r);
        this.opaqueExpressions = IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)r.getAllContents(), OpaqueExpression.class));
        this.opaqueBehaviors = IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)r.getAllContents(), OpaqueBehavior.class));
    }

    private String prototypeToC(OpaqueBehavior e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("static void c_function_");
        String _variableName = UmlSerializerExtensions.variableName((EObject)e);
        _builder.append(_variableName);
        _builder.append("(ActiveObject * ao, void * params);");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private String prototypeToC(OpaqueExpression e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("static bool c_function_");
        String _variableName = UmlSerializerExtensions.variableName((EObject)e);
        _builder.append(_variableName);
        _builder.append("(ActiveObject * ao);");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private Class getClassContainer(EObject e) {
        Class _xblockexpression = null;
        EObject classContainer = e;
        while (!classContainer.eClass().getName().equals("Class")) {
            classContainer = classContainer.eContainer();
        }
        _xblockexpression = (Class)classContainer;
        return _xblockexpression;
    }

    private String toC(OpaqueBehavior e) {
        Event _event;
        EList signal_params;
        EObject _eContainer;
        Transition container;
        Trigger trigger;
        String _xblockexpression = null;
        Signal signal = null;
        boolean hasParams = false;
        if (e.eContainer() != null && e.eContainer() instanceof Transition && (trigger = (Trigger)IterableExtensions.head((Iterable)(container = (Transition)(_eContainer = e.eContainer())).getTriggers())) != null && (signal_params = (signal = ((SignalEvent)(_event = trigger.getEvent())).getSignal()).getOwnedAttributes()) != null && ((Object[])Conversions.unwrapArray((Object)signal_params, Object.class)).length > 0) {
            hasParams = true;
        }
        Class classContainer = this.getClassContainer((EObject)e);
        int index = -1;
        for (int i = 0; i < e.getLanguages().size() && index == -1; ++i) {
            boolean _equals = ((String)e.getLanguages().get(i)).equals(C_LANGUAGE_NAME);
            if (!_equals) continue;
            index = i;
        }
        String _xifexpression = null;
        if (index != -1) {
            String _xblockexpression_1 = null;
            List<MatchingUnitC> units = this.matcher.matchAll((String)e.getBodies().get(index));
            String body = this.convertor.convertAll(units, classContainer, true);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("static void c_function_");
            String _variableName = UmlSerializerExtensions.variableName((EObject)e);
            _builder.append(_variableName);
            _builder.append("(ActiveObject * ao, void * gen_params) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            StringConcatenation _xifexpression_1 = null;
            if (hasParams) {
                StringConcatenation _builder_1 = new StringConcatenation();
                String _name = signal.getName();
                _builder_1.append(_name);
                _builder_1.append("_signal_parameters params;");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("memcpy(&params, gen_params, sizeof(");
                String _name_1 = signal.getName();
                _builder_1.append(_name_1);
                _builder_1.append("_signal_parameters));");
                _builder_1.newLineIfNotEmpty();
                _xifexpression_1 = _builder_1;
            }
            _builder.append(_xifexpression_1, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append(body, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
            _xifexpression = _xblockexpression_1 = _builder.toString();
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private String toC(OpaqueExpression e) {
        String _xblockexpression = null;
        Class classContainer = this.getClassContainer((EObject)e);
        int index = -1;
        for (int i = 0; i < e.getLanguages().size() && index == -1; ++i) {
            boolean _equals = ((String)e.getLanguages().get(i)).equals(C_LANGUAGE_NAME);
            if (!_equals) continue;
            index = i;
        }
        String _xifexpression = null;
        if (index != -1) {
            String _xblockexpression_1 = null;
            List<MatchingUnitC> units = this.matcher.matchAll((String)e.getBodies().get(index));
            String body = this.convertor.convertAll(units, classContainer, false);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("static bool c_function_");
            String _variableName = UmlSerializerExtensions.variableName((EObject)e);
            _builder.append(_variableName);
            _builder.append("(ActiveObject * ao) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("return (");
            _builder.append(body, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
            _xifexpression = _xblockexpression_1 = _builder.toString();
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String serializeEffectsDeclarations() {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> this.prototypeToC((OpaqueBehavior)it);
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(this.opaqueBehaviors, (Functions.Function1)_function));
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String serializeEffects() {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> this.toC((OpaqueBehavior)it);
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(this.opaqueBehaviors, (Functions.Function1)_function));
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String serializeGuardsDeclarations() {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> this.prototypeToC((OpaqueExpression)it);
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(this.opaqueExpressions, (Functions.Function1)_function));
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String serializeGuards() {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> this.toC((OpaqueExpression)it);
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(this.opaqueExpressions, (Functions.Function1)_function));
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }
}

