/*
 * Decompiled with CFR 0.152.
 */
package properties.PropositionalLogic.interpreter;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import properties.PropositionalLogic.PropositionalLogicModel.Atom;
import properties.PropositionalLogic.PropositionalLogicModel.Declaration;
import properties.PropositionalLogic.PropositionalLogicModel.DeclarationBlock;
import properties.PropositionalLogic.PropositionalLogicModel.Expression;
import properties.PropositionalLogic.PropositionalLogicModel.ExpressionDeclaration;
import properties.PropositionalLogic.PropositionalLogicModel.ExpressionReference;
import properties.PropositionalLogic.PropositionalLogicModel.False;
import properties.PropositionalLogic.PropositionalLogicModel.LetExpression;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalConjunction;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalDisjunction;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalEquivalence;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalImplication;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalNegation;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalXOR;
import properties.PropositionalLogic.PropositionalLogicModel.True;
import properties.PropositionalLogic.PropositionalLogicModel.util.PropositionalLogicModelSwitch;
import properties.PropositionalLogic.interpreter.AtomEvaluatorDispatcher;
import properties.PropositionalLogic.interpreter.IAtomEvaluator;

public class Evaluator
extends PropositionalLogicModelSwitch<Boolean> {
    AtomEvaluatorDispatcher atomEvaluator = new AtomEvaluatorDispatcher();
    Stack<Map<String, Boolean>> executionStack = new Stack();

    public void setDefaultEvaluator(IAtomEvaluator evaluator) {
        this.atomEvaluator.setDefaultEvaluator(evaluator);
    }

    public void addAtomEvaluator(String language, IAtomEvaluator evaluator) {
        this.atomEvaluator.addEvaluator(language, evaluator);
    }

    public Map<String, Boolean> globalFrame() {
        if (this.executionStack.isEmpty()) {
            return null;
        }
        return (Map)this.executionStack.get(0);
    }

    Map<String, Boolean> pushFrame() {
        return this.executionStack.push(new HashMap());
    }

    Map<String, Boolean> popFrame() {
        return this.executionStack.pop();
    }

    Map<String, Boolean> currentFrame() {
        return this.executionStack.peek();
    }

    Boolean lookup(Declaration declaration) {
        for (int i = this.executionStack.size() - 1; i >= 0; --i) {
            Map frame = (Map)this.executionStack.get(i);
            Boolean value = (Boolean)frame.get(declaration.getName());
            if (value == null) continue;
            return value;
        }
        throw new RuntimeException("The declaration '" + declaration.getName() + "' was not found on the execution stack");
    }

    @Override
    public Boolean caseTrue(True object) {
        return true;
    }

    @Override
    public Boolean caseFalse(False object) {
        return false;
    }

    @Override
    public Boolean caseAtom(Atom object) {
        return this.atomEvaluator.evaluate(object);
    }

    @Override
    public Boolean caseExpressionReference(ExpressionReference object) {
        return this.lookup(object.getExp());
    }

    @Override
    public Boolean caseLogicalNegation(LogicalNegation object) {
        return (Boolean)this.doSwitch(object.getOperand()) == false;
    }

    @Override
    public Boolean caseLogicalConjunction(LogicalConjunction object) {
        Boolean lhs = (Boolean)this.doSwitch(object.getLhs());
        Boolean rhs = (Boolean)this.doSwitch(object.getRhs());
        return lhs != false && rhs != false;
    }

    @Override
    public Boolean caseLogicalDisjunction(LogicalDisjunction object) {
        Boolean lhs = (Boolean)this.doSwitch(object.getLhs());
        Boolean rhs = (Boolean)this.doSwitch(object.getRhs());
        return lhs != false || rhs != false;
    }

    @Override
    public Boolean caseLogicalXOR(LogicalXOR object) {
        Boolean lhs = (Boolean)this.doSwitch(object.getLhs());
        Boolean rhs = (Boolean)this.doSwitch(object.getRhs());
        return lhs ^ rhs;
    }

    @Override
    public Boolean caseLogicalImplication(LogicalImplication object) {
        Boolean lhs = (Boolean)this.doSwitch(object.getLhs());
        Boolean rhs = (Boolean)this.doSwitch(object.getRhs());
        return lhs == false || rhs != false;
    }

    @Override
    public Boolean caseLogicalEquivalence(LogicalEquivalence object) {
        Boolean lhs = (Boolean)this.doSwitch(object.getLhs());
        Boolean rhs = (Boolean)this.doSwitch(object.getRhs());
        return !(lhs ^ rhs);
    }

    @Override
    public Boolean caseExpressionDeclaration(ExpressionDeclaration object) {
        Boolean value = (Boolean)this.doSwitch(object.getExpression());
        if (this.currentFrame().containsKey(object)) {
            throw new RuntimeException("strangely there is already a value for '" + object.getName() + "' in the currentFrame");
        }
        this.currentFrame().put(object.getName(), value);
        return value;
    }

    @Override
    public Boolean caseLetExpression(LetExpression object) {
        this.pushFrame();
        for (ExpressionDeclaration decl : object.getDeclarations()) {
            this.doSwitch(decl);
        }
        Boolean result = (Boolean)this.doSwitch(object.getExpression());
        this.popFrame();
        return result;
    }

    @Override
    public Boolean caseDeclarationBlock(DeclarationBlock object) {
        if (this.executionStack.isEmpty()) {
            this.pushFrame();
        }
        Boolean value = false;
        for (ExpressionDeclaration decl : object.getDeclarations()) {
            value = (Boolean)this.doSwitch(decl);
        }
        return value;
    }

    public boolean evaluate(Expression exp) {
        return (Boolean)this.doSwitch(exp);
    }

    public Map<String, Boolean> evaluate(DeclarationBlock block) {
        this.doSwitch(block);
        return this.globalFrame();
    }
}

