/*
 * Decompiled with CFR 0.152.
 */
package obp.partition;

import java.util.LinkedList;
import java.util.List;
import obp.cc.ConcreteContext;
import obp.cc.State;
import obp.cc.Transition;
import obp.partition.ConcreteContextPartitioner;
import obp.transfo.cc.ConcreteContextCache;
import obp.util.ConcreteContextUtil;

public class PathPartioner
extends ConcreteContextPartitioner {
    private int count;
    private final LinkedList<ConcreteContextUtil.Context> context = new LinkedList();
    private final ConcreteContext cc;
    private final ConcreteContextCache cache;

    public PathPartioner(ConcreteContext cc) {
        this.cc = cc;
        this.count = 0;
        this.cache = new ConcreteContextCache(cc);
        this.context.addLast(new ConcreteContextUtil.Context(cc.getStartState(), -1));
    }

    @Override
    public boolean hasNext() {
        return !this.context.isEmpty();
    }

    @Override
    public ConcreteContext next() {
        ConcreteContext next = null;
        while (!this.context.isEmpty()) {
            ConcreteContextUtil.Context current = this.context.peekLast();
            ++current.transitionIndex;
            List<Transition> outTransitions = this.cache.getOutTransitions(current.state);
            if (current.transitionIndex < outTransitions.size()) {
                if (next != null) {
                    --current.transitionIndex;
                    return next;
                }
                Transition transition = outTransitions.get(current.transitionIndex);
                State state = transition.getTarget();
                if (this.cc.getStopState().equals(state)) {
                    next = this.createFromTrace(this.context);
                    continue;
                }
                this.context.addLast(new ConcreteContextUtil.Context(state, -1));
                continue;
            }
            this.context.removeLast();
        }
        if (next == null) {
            throw new IndexOutOfBoundsException("No next available");
        }
        return next;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    private ConcreteContext createFromTrace(List<ConcreteContextUtil.Context> trace) {
        ConcreteContext newCc = new ConcreteContext();
        ConcreteContextUtil.copyObserversAndAsserts(this.cc, newCc);
        newCc.setName("Path" + this.count++);
        State currentState = new State();
        newCc.addState(currentState);
        newCc.setStartState(currentState);
        for (ConcreteContextUtil.Context context : trace) {
            State nextState = new State();
            newCc.addState(nextState);
            Transition transition = this.cache.getOutTransitions(context.state).get(context.transitionIndex);
            Transition newTransition = ConcreteContextUtil.copyTransition(transition);
            newTransition.setSource(currentState);
            newTransition.setTarget(nextState);
            newCc.addTransition(newTransition);
            currentState = nextState;
        }
        newCc.setStopState(currentState);
        return newCc;
    }
}

