/*
 * Decompiled with CFR 0.152.
 */
package obp.if2.behaviour.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.if2.If2Visitor;
import obp.if2.behaviour.statements.ActionStatement;
import obp.if2.data.Expression;
import obp.if2.structure.Signal;

public class OutputAction
extends ActionStatement {
    private Signal signal;
    private final List<Expression> parametersList = new ArrayList<Expression>();
    private Expression via;
    private Expression to;

    public Signal getSignal() {
        return this.signal;
    }

    public void setSignal(Signal newValue) {
        if (this.signal == null ? newValue != null : !this.signal.equals(newValue)) {
            this.signal = newValue;
        }
    }

    public List<Expression> getParametersList() {
        return Collections.unmodifiableList(this.parametersList);
    }

    public int getParametersCount() {
        return this.parametersList.size();
    }

    public Expression getParameters(int index) {
        if (index < 0 || index >= this.getParametersCount()) {
            return null;
        }
        return this.parametersList.get(index);
    }

    public void addParameters(Expression newValue) {
        this.addParameters(this.getParametersCount(), newValue);
    }

    public void addParameters(int index, Expression newValue) {
        this.parametersList.add(index, newValue);
    }

    public Expression setParameters(int index, Expression newValue) {
        return this.parametersList.set(index, newValue);
    }

    public void addAllParameters(Collection<Expression> toAddList) {
        for (Expression newValue : toAddList) {
            this.addParameters(this.getParametersCount(), newValue);
        }
    }

    public void removeParameters(Expression value) {
        int index = this.parametersList.indexOf(value);
        if (index >= 0) {
            this.removeParameters(index);
        }
    }

    public void removeParameters(int index) {
        this.parametersList.remove(index);
    }

    public Expression getVia() {
        return this.via;
    }

    public void setVia(Expression newValue) {
        if (this.via == null ? newValue != null : !this.via.equals(newValue)) {
            this.via = newValue;
        }
    }

    public Expression getTo() {
        return this.to;
    }

    public void setTo(Expression newValue) {
        if (this.to == null ? newValue != null : !this.to.equals(newValue)) {
            this.to = newValue;
        }
    }

    @Override
    public void accept(If2Visitor visitor) {
        visitor.visitOutputAction(this);
    }
}

