/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.core;

import java.util.Arrays;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.SymbolsTable;
import obp.explorer.runtime.core.Channel;
import obp.explorer.runtime.core.ITransitionExecutor;
import obp.explorer.runtime.core.Transition;

public class BroadcastChannel
extends Channel {
    private final int[] transitionCountByInput;
    private final int[] transitionIndexByInput;
    public final int requiredInputCount;
    private int inputPossibilitiesCount;
    private int[] transitionCountByOutput;
    private int[] transitionIndexByOutput;
    public int requiredOutputCount;
    private int outputPossibilitiesCount;

    public BroadcastChannel(String name, SymbolsTable symbols, int requiredInputCount, int requiredOutputCount) {
        super(name, symbols);
        this.requiredInputCount = requiredInputCount;
        this.transitionCountByInput = new int[requiredInputCount];
        this.transitionIndexByInput = new int[requiredInputCount];
        this.requiredOutputCount = requiredOutputCount;
        this.transitionCountByOutput = new int[requiredOutputCount];
        this.transitionIndexByOutput = new int[requiredOutputCount];
    }

    public BroadcastChannel(String name, SymbolsTable symbols, int requiredInputCount, int requiredOutputCount, int minBound, boolean minBoundStrict) {
        super(name, symbols, minBound, minBoundStrict);
        this.requiredInputCount = requiredInputCount;
        this.transitionCountByInput = new int[requiredInputCount];
        this.transitionIndexByInput = new int[requiredInputCount];
        this.requiredOutputCount = requiredOutputCount;
        this.transitionCountByOutput = new int[requiredOutputCount];
        this.transitionIndexByOutput = new int[requiredOutputCount];
    }

    public BroadcastChannel(String name, SymbolsTable symbols, int requiredInputCount, int requiredOutputCount, int minBound, boolean minBoundStrict, int maxBound, boolean maxBoundStrict) {
        super(name, symbols, minBound, minBoundStrict, maxBound, maxBoundStrict);
        this.requiredInputCount = requiredInputCount;
        this.transitionCountByInput = new int[requiredInputCount];
        this.transitionIndexByInput = new int[requiredInputCount];
        this.requiredOutputCount = requiredOutputCount;
        this.transitionCountByOutput = new int[requiredOutputCount];
        this.transitionIndexByOutput = new int[requiredOutputCount];
    }

    public void addOutput() {
        ++this.requiredOutputCount;
        if (this.requiredOutputCount > this.transitionCountByOutput.length) {
            this.transitionCountByOutput = Arrays.copyOf(this.transitionCountByOutput, this.transitionCountByOutput.length == 0 ? 1 : this.transitionCountByOutput.length * 2);
        }
        if (this.requiredOutputCount > this.transitionIndexByOutput.length) {
            this.transitionIndexByOutput = Arrays.copyOf(this.transitionIndexByOutput, this.transitionIndexByOutput.length == 0 ? 1 : this.transitionIndexByOutput.length * 2);
        }
    }

    @Override
    public boolean isActive(Transition[] outputs, int outputCount, Transition[] inputs, int inputCount) {
        Transition transition;
        int i;
        if (outputCount < this.requiredOutputCount || inputCount < this.requiredInputCount) {
            return false;
        }
        Arrays.fill(this.transitionCountByOutput, 0);
        Arrays.fill(this.transitionCountByInput, 0);
        this.outputPossibilitiesCount = 1;
        short currentBehavior = -1;
        int currentIndex = -1;
        for (i = 0; i < outputCount; ++i) {
            transition = outputs[i];
            if (transition.behaviorId > currentBehavior) {
                if (currentIndex >= 0) {
                    this.outputPossibilitiesCount *= this.transitionCountByOutput[currentIndex];
                }
                currentBehavior = transition.behaviorId;
            }
            int n = ++currentIndex;
            this.transitionCountByOutput[n] = this.transitionCountByOutput[n] + 1;
        }
        this.outputPossibilitiesCount *= this.transitionCountByOutput[currentIndex];
        if (currentIndex < this.requiredOutputCount - 1) {
            return false;
        }
        this.inputPossibilitiesCount = 1;
        currentBehavior = -1;
        currentIndex = -1;
        for (i = 0; i < inputCount; ++i) {
            transition = inputs[i];
            if (transition.behaviorId > currentBehavior) {
                if (currentIndex >= 0) {
                    this.inputPossibilitiesCount *= this.transitionCountByInput[currentIndex];
                }
                currentBehavior = transition.behaviorId;
            }
            int n = ++currentIndex;
            this.transitionCountByInput[n] = this.transitionCountByInput[n] + 1;
        }
        this.inputPossibilitiesCount *= this.transitionCountByInput[currentIndex];
        return currentIndex >= this.requiredInputCount - 1;
    }

    @Override
    protected void computeSynchronizations(Configuration configuration, Transition[] outputs, int outputCount, Transition[] inputs, int inputCount, ITransitionExecutor executer) {
        Arrays.fill(this.transitionIndexByOutput, 0);
        Arrays.fill(this.transitionIndexByInput, 0);
        this.executeOneTransition(configuration, outputs, outputCount, inputs, inputCount, executer);
        for (int j = 0; j < this.inputPossibilitiesCount - 1; ++j) {
            this.nextInput();
            this.executeOneTransition(configuration, outputs, outputCount, inputs, inputCount, executer);
        }
        for (int i = 0; i < this.outputPossibilitiesCount - 1; ++i) {
            this.nextOutput();
            Arrays.fill(this.transitionIndexByInput, 0);
            this.executeOneTransition(configuration, outputs, outputCount, inputs, inputCount, executer);
            for (int j = 0; j < this.inputPossibilitiesCount - 1; ++j) {
                this.nextInput();
                this.executeOneTransition(configuration, outputs, outputCount, inputs, inputCount, executer);
            }
        }
    }

    private void nextOutput() {
        boolean hasCarry = true;
        int current = 0;
        while (hasCarry) {
            int n = current;
            this.transitionIndexByOutput[n] = this.transitionIndexByOutput[n] + 1;
            if (this.transitionIndexByOutput[current] == this.transitionCountByOutput[current]) {
                this.transitionIndexByOutput[current] = 0;
            } else {
                hasCarry = false;
            }
            ++current;
        }
    }

    private void nextInput() {
        boolean hasCarry = true;
        int current = 0;
        while (hasCarry) {
            int n = current;
            this.transitionIndexByInput[n] = this.transitionIndexByInput[n] + 1;
            if (this.transitionIndexByInput[current] == this.transitionCountByInput[current]) {
                this.transitionIndexByInput[current] = 0;
            } else {
                hasCarry = false;
            }
            ++current;
        }
    }

    private void executeOneTransition(Configuration configuration, Transition[] outputs, int outputCount, Transition[] inputs, int inputCount, ITransitionExecutor executor) {
        int i;
        int index = 0;
        for (i = 0; i < this.requiredOutputCount; ++i) {
            executor.addOutput(outputs[index += this.transitionIndexByOutput[i]]);
            index += this.transitionCountByOutput[i] - this.transitionIndexByOutput[i];
        }
        index = 0;
        for (i = 0; i < this.requiredInputCount; ++i) {
            executor.addInput(inputs[index += this.transitionIndexByInput[i]]);
            index += this.transitionCountByInput[i] - this.transitionIndexByInput[i];
        }
        executor.execute(configuration, this);
    }
}

