/*
 * Decompiled with CFR 0.152.
 */
package org.petitparser.grammar.xml;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.petitparser.grammar.xml.XmlGrammar;
import org.petitparser.grammar.xml.ast.XmlAttribute;
import org.petitparser.grammar.xml.ast.XmlCdata;
import org.petitparser.grammar.xml.ast.XmlComment;
import org.petitparser.grammar.xml.ast.XmlDoctype;
import org.petitparser.grammar.xml.ast.XmlDocument;
import org.petitparser.grammar.xml.ast.XmlElement;
import org.petitparser.grammar.xml.ast.XmlName;
import org.petitparser.grammar.xml.ast.XmlNode;
import org.petitparser.grammar.xml.ast.XmlProcessing;
import org.petitparser.grammar.xml.ast.XmlText;

public class XmlParser
extends XmlGrammar {
    @Override
    protected void initialize() {
        super.initialize();
        this.action("attribute", new Function<List<?>, XmlAttribute>(){

            @Override
            public XmlAttribute apply(List<?> argument) {
                return new XmlAttribute((XmlName)argument.get(0), (String)argument.get(1));
            }
        });
        this.action("comment", XmlComment::new);
        this.action("cdata", XmlCdata::new);
        this.action("doctype", XmlDoctype::new);
        this.action("document", new Function<List<XmlNode>, XmlDocument>(){

            @Override
            public XmlDocument apply(List<XmlNode> nodes) {
                return new XmlDocument(nodes.stream().filter(Objects::nonNull).collect(Collectors.toList()));
            }
        });
        this.action("element", new Function<List<?>, XmlElement>(){

            @Override
            public XmlElement apply(List<?> list) {
                return new XmlElement((XmlName)list.get(0), (Collection)list.get(1), (Collection)list.get(2));
            }
        });
        this.action("processing", new Function<List<String>, XmlProcessing>(){

            @Override
            public XmlProcessing apply(List<String> list) {
                return new XmlProcessing(list.get(0), list.get(1));
            }
        });
        this.action("qualified", XmlName::new);
        this.action("characterData", XmlText::new);
    }
}

