/*
 * Decompiled with CFR 0.152.
 */
package org.xid.basics.sexp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xid.basics.sexp.SExp;
import org.xid.basics.sexp.SExpVisitor;

public class SList
extends SExp {
    private final List<SExp> childList = new ArrayList<SExp>();

    public SList() {
    }

    public SList(SExp ... children) {
        for (SExp child : children) {
            this.addChildAndOpposite(child);
        }
    }

    public SList(List<SExp> children) {
        for (SExp child : children) {
            this.addChildAndOpposite(child);
        }
    }

    @Override
    public boolean hasConstructor() {
        return this.firstChildIsAtom();
    }

    @Override
    public boolean isNull() {
        return this.childList.size() == 2 && this.childList.get(1).isNull();
    }

    @Override
    public String getConstructor() {
        if (this.childList.isEmpty()) {
            return null;
        }
        return this.childList.get(0).getValue();
    }

    @Override
    public List<SExp> getChildList() {
        return Collections.unmodifiableList(this.childList);
    }

    @Override
    public int getChildCount() {
        return this.childList.size();
    }

    @Override
    public SExp getChild(int index) {
        if (index < 0 || index >= this.getChildCount()) {
            return null;
        }
        return this.childList.get(index);
    }

    @Override
    public void addChild(SExp newValue) {
        this.addChild(this.getChildCount(), newValue);
    }

    @Override
    public void addChild(int index, SExp newValue) {
        this.childList.add(index, newValue);
    }

    @Override
    public SExp setChild(int index, SExp value) {
        return this.childList.set(index, value);
    }

    @Override
    public void removeChild(SExp value) {
        int index = this.childList.indexOf(value);
        if (index >= 0) {
            this.removeChild(index);
        }
    }

    @Override
    public void removeChild(int index) {
        this.childList.remove(index);
    }

    @Override
    public void addChildAndOpposite(SExp newValue) {
        this.addChild(newValue);
        if (newValue != null) {
            newValue.setParent(this);
        }
    }

    @Override
    public void addChildAndOpposite(int index, SExp newValue) {
        this.addChild(index, newValue);
        if (newValue != null) {
            newValue.setParent(this);
        }
    }

    @Override
    public SExp setChildAndOpposite(int index, SExp newValue) {
        SExp oldChild = this.setChild(index, newValue);
        if (newValue != null) {
            newValue.setParent(this);
        }
        if (oldChild != null) {
            oldChild.setParent(null);
        }
        return oldChild;
    }

    @Override
    public void removeChildAndOpposite(SExp removed) {
        this.removeChild(removed);
        if (removed != null) {
            removed.setParent(null);
        }
    }

    @Override
    public void removeChildAndOpposite(int index) {
        SExp removed = this.childList.get(index);
        this.removeChild(index);
        if (removed != null) {
            removed.setParent(null);
        }
    }

    @Override
    public void accept(SExpVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public SList copy() {
        SList copy = new SList();
        for (SExp child : this.childList) {
            copy.addChild(child.copy());
        }
        return copy;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SList) {
            SList other = (SList)obj;
            return this.childList.equals(other.childList);
        }
        return false;
    }

    private boolean allChildrenAreAtoms() {
        for (SExp child : this.childList) {
            if (child.isAtom()) continue;
            return false;
        }
        return true;
    }

    private boolean firstChildIsAtom() {
        return this.childList.size() > 0 && this.childList.get(0).isAtom();
    }

    @Override
    public String toStringMultiline(int level) {
        String tabs = this.tabs(level);
        String nl = this.nl();
        StringBuilder result = new StringBuilder();
        result.append(tabs);
        result.append("(");
        int size = this.childList.size();
        if (size > 0) {
            if (this.allChildrenAreAtoms()) {
                for (int i = 0; i < size; ++i) {
                    if (i > 0) {
                        result.append(" ");
                    }
                    SExp child = this.childList.get(i);
                    result.append(child.toStringOneline());
                }
            } else {
                int start = 0;
                if (this.hasConstructor()) {
                    result.append(this.getConstructor());
                    start = 1;
                }
                if (size > start) {
                    result.append(nl);
                    for (int i = start; i < size; ++i) {
                        SExp child = this.childList.get(i);
                        result.append(child.toStringMultiline(level + 1));
                    }
                    result.append(tabs);
                }
            }
        }
        result.append(")");
        result.append(nl);
        return result.toString();
    }

    @Override
    public String toStringOneline() {
        StringBuilder text = new StringBuilder();
        text.append("(");
        for (SExp exp : this.childList) {
            if (text.length() > 1) {
                text.append(" ");
            }
            text.append(exp.toStringOneline());
        }
        text.append(")");
        return text.toString();
    }

    public String toString() {
        return this.toStringOneline();
    }
}

