/*
 * Decompiled with CFR 0.152.
 */
package spinja.search;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import spinja.model.Model;
import spinja.model.Transition;
import spinja.search.Simulation;
import spinja.search.TransitionCalculator;

public class RandomSimulation<M extends Model<T>, T extends Transition>
extends Simulation<M, T> {
    private final Random rand;
    private final List<T> enabled = new ArrayList<T>();

    public RandomSimulation(M m, TransitionCalculator<M, T> transitionCalculator) {
        super(m, transitionCalculator);
        this.rand = new Random(System.nanoTime());
    }

    @Override
    public T nextTransition() {
        Object e = null;
        this.enabled.clear();
        while ((e = this.nextTransition.next(this.model, e)) != null) {
            this.enabled.add(e);
        }
        if (this.enabled.isEmpty()) {
            return null;
        }
        return (T)((Transition)this.enabled.get(this.rand.nextInt(this.enabled.size())));
    }
}

