/*
 * Decompiled with CFR 0.152.
 */
package spinja.promela.compiler.actions;

import java.util.ArrayList;
import java.util.List;
import spinja.promela.compiler.Proctype;
import spinja.promela.compiler.actions.Action;
import spinja.promela.compiler.expression.CompoundExpression;
import spinja.promela.compiler.expression.Expression;
import spinja.promela.compiler.expression.Identifier;
import spinja.promela.compiler.parser.ParseException;
import spinja.promela.compiler.parser.Token;
import spinja.promela.compiler.variable.Variable;
import spinja.promela.compiler.variable.VariableAccess;
import spinja.util.StringWriter;

public class ChannelReadAction
extends Action
implements CompoundExpression {
    private final Variable var;
    private final List<Expression> exprs;

    public ChannelReadAction(Token token, Variable variable) {
        super(token);
        this.var = variable;
        this.exprs = new ArrayList<Expression>();
    }

    @Override
    public void addExpression(Expression expression) {
        this.exprs.add(expression);
        if (!(expression instanceof Identifier)) {
            for (VariableAccess variableAccess : expression.readVariables()) {
                variableAccess.getVar().setRead(true);
            }
        } else {
            ((Identifier)expression).getVariable().setWritten(true);
        }
    }

    @Override
    public String getEnabledExpression() {
        return "false";
    }

    @Override
    public boolean isLocal(Proctype proctype) {
        if (!proctype.isXR(this.var)) {
            return false;
        }
        for (Expression expression : this.exprs) {
            if (expression instanceof Identifier) {
                Variable variable = ((Identifier)expression).getVariable();
                if (proctype.hasVariable(variable.getName())) continue;
                return false;
            }
            for (VariableAccess variableAccess : expression.readVariables()) {
                if (proctype.hasVariable(variableAccess.getVar().getName())) continue;
                return false;
            }
        }
        return super.isLocal(proctype);
    }

    @Override
    public void printEnabledFunction(StringWriter stringWriter) throws ParseException {
        stringWriter.appendLine("public boolean isEnabled() {");
        stringWriter.indent();
        stringWriter.appendLine("if(", this.var, " == -1 || _channels[", this.var, "].isRendezVous() || !_channels[", this.var, "].canRead()) {");
        stringWriter.indent();
        stringWriter.appendLine("return false;");
        stringWriter.outdent();
        stringWriter.appendLine("} else {");
        stringWriter.indent();
        stringWriter.appendLine("int[] _tmp = _channels[", this.var, "].peek();");
        stringWriter.appendLine("if(_tmp.length != ", this.exprs.size(), ") throw new UnexpectedStateException(\"Channel returned the wrong number of variables\");");
        boolean bl = true;
        for (int i = 0; i < this.exprs.size(); ++i) {
            Expression expression = this.exprs.get(i);
            if (expression instanceof Identifier) continue;
            stringWriter.appendLine(bl ? "return " : " && ", "_tmp[", i, "] == ", expression.getIntExpression());
            bl = false;
        }
        if (bl) {
            stringWriter.appendLine("return true;");
        } else {
            stringWriter.removePostfix().append(";").appendPostfix();
        }
        stringWriter.outdent();
        stringWriter.appendLine("}");
        stringWriter.outdent();
        stringWriter.appendLine("}");
    }

    @Override
    public void printExtraFunctions(StringWriter stringWriter) throws ParseException {
        stringWriter.appendLine(new Object[0]);
        stringWriter.appendLine("public boolean canReadRendezvous(int[] _values) {");
        stringWriter.indent();
        stringWriter.appendLine("return _channels[", this.var, "].isRendezVous()");
        stringWriter.appendLine("         && _values.length == ", this.exprs.size() + 1);
        stringWriter.appendLine("         && _values[0] == ", this.var);
        for (int i = 0; i < this.exprs.size(); ++i) {
            if (this.exprs.get(i) instanceof Identifier) continue;
            stringWriter.appendLine("         && _values[", i + 1, "] == ", this.exprs.get(i).getIntExpression());
        }
        stringWriter.removePostfix().append(";").appendPostfix();
        stringWriter.outdent();
        stringWriter.appendLine("}");
        stringWriter.appendLine(new Object[0]);
    }

    public List<Identifier> getChangedVariables() {
        ArrayList<Identifier> arrayList = new ArrayList<Identifier>(this.exprs.size());
        for (Expression expression : this.exprs) {
            if (!(expression instanceof Identifier)) continue;
            arrayList.add((Identifier)expression);
        }
        return arrayList;
    }

    @Override
    public void printTakeStatement(StringWriter stringWriter) throws ParseException {
        stringWriter.appendLine("int[] _tmp = _channels[", this.var, "].read();");
        for (int i = 0; i < this.exprs.size(); ++i) {
            Expression expression = this.exprs.get(i);
            if (!(expression instanceof Identifier)) continue;
            String string = expression.getResultType().getMask();
            stringWriter.appendLine(expression.getIntExpression(), " = _tmp[", i, "]", string == null ? "" : " & " + string, "; ");
        }
    }

    @Override
    public void printUndoStatement(StringWriter stringWriter) throws ParseException {
        stringWriter.appendPrefix().append("_channels[").append(this.var).append("].sendFirst(");
        for (Expression expression : this.exprs) {
            stringWriter.append(expression.getIntExpression()).append(", ");
        }
        stringWriter.setLength(stringWriter.length() - 2);
        stringWriter.append(");").appendPostfix();
    }

    @Override
    public String toString() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.append(this.var.getName()).append("?");
        for (Expression expression : this.exprs) {
            stringWriter.append(expression.toString()).append(",");
        }
        stringWriter.setLength(stringWriter.length() - 1);
        return stringWriter.toString();
    }
}

