/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import impl.org.controlsfx.behavior.SnapshotViewBehavior;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeType;
import org.controlsfx.control.SnapshotView;

public class SnapshotViewSkin
extends BehaviorSkinBase<SnapshotView, SnapshotViewBehavior> {
    private Node node;
    private final GridPane gridPane = SnapshotViewSkin.createGridPane();
    private final Rectangle selectedArea = new Rectangle();
    private final Rectangle unselectedArea = new Rectangle();
    private final Node mouseNode = this.createMouseNode();

    public SnapshotViewSkin(SnapshotView snapshotView) {
        super((Control)snapshotView, (BehaviorBase)new SnapshotViewBehavior(snapshotView));
        this.buildSceneGraph();
        this.initializeAreas();
        this.registerChangeListener((ObservableValue)snapshotView.nodeProperty(), "NODE");
        this.registerChangeListener((ObservableValue)snapshotView.selectionProperty(), "SELECTION");
    }

    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("NODE".equals(p)) {
            this.updateNode();
        } else if ("SELECTION".equals(p)) {
            this.updateSelection();
        }
    }

    private static GridPane createGridPane() {
        GridPane pane = new GridPane();
        pane.setAlignment(Pos.CENTER);
        return pane;
    }

    private Node createMouseNode() {
        Rectangle mouseNode = new Rectangle();
        mouseNode.setFill((Paint)Color.TRANSPARENT);
        mouseNode.setManaged(false);
        mouseNode.widthProperty().bind((ObservableValue)((SnapshotView)this.getSkinnable()).widthProperty());
        mouseNode.heightProperty().bind((ObservableValue)((SnapshotView)this.getSkinnable()).heightProperty());
        mouseNode.addEventHandler(MouseEvent.ANY, this::handleMouseEvent);
        mouseNode.mouseTransparentProperty().bind((ObservableValue)((SnapshotView)this.getSkinnable()).selectionMouseTransparentProperty());
        return mouseNode;
    }

    private void buildSceneGraph() {
        this.getChildren().addAll((Object[])new Node[]{this.gridPane, this.unselectedArea, this.selectedArea, this.mouseNode});
        this.updateNode();
    }

    private void initializeAreas() {
        this.styleAreas();
        this.bindAreaCoordinatesTogether();
        this.bindAreaVisibilityToSelection();
    }

    private void styleAreas() {
        this.selectedArea.fillProperty().bind(((SnapshotView)this.getSkinnable()).selectionAreaFillProperty());
        this.selectedArea.strokeProperty().bind(((SnapshotView)this.getSkinnable()).selectionBorderPaintProperty());
        this.selectedArea.strokeWidthProperty().bind((ObservableValue)((SnapshotView)this.getSkinnable()).selectionBorderWidthProperty());
        this.selectedArea.setStrokeType(StrokeType.OUTSIDE);
        this.selectedArea.setManaged(false);
        this.selectedArea.setMouseTransparent(true);
        this.unselectedArea.setFill((Paint)Color.TRANSPARENT);
        this.unselectedArea.strokeProperty().bind(((SnapshotView)this.getSkinnable()).unselectedAreaFillProperty());
        this.unselectedArea.strokeWidthProperty().bind((ObservableValue)Bindings.max((ObservableNumberValue)((SnapshotView)this.getSkinnable()).widthProperty(), (ObservableNumberValue)((SnapshotView)this.getSkinnable()).heightProperty()));
        this.unselectedArea.setStrokeType(StrokeType.OUTSIDE);
        this.unselectedArea.setManaged(false);
        this.unselectedArea.setMouseTransparent(true);
    }

    private void bindAreaCoordinatesTogether() {
        this.unselectedArea.xProperty().bind((ObservableValue)this.selectedArea.xProperty());
        this.unselectedArea.yProperty().bind((ObservableValue)this.selectedArea.yProperty());
        this.unselectedArea.widthProperty().bind((ObservableValue)this.selectedArea.widthProperty());
        this.unselectedArea.heightProperty().bind((ObservableValue)this.selectedArea.heightProperty());
    }

    private void bindAreaVisibilityToSelection() {
        ReadOnlyBooleanProperty selectionExists = ((SnapshotView)this.getSkinnable()).hasSelectionProperty();
        BooleanProperty selectionActive = ((SnapshotView)this.getSkinnable()).selectionActiveProperty();
        BooleanBinding existsAndActive = Bindings.and((ObservableBooleanValue)selectionExists, (ObservableBooleanValue)selectionActive);
        this.selectedArea.visibleProperty().bind((ObservableValue)existsAndActive);
        this.unselectedArea.visibleProperty().bind((ObservableValue)existsAndActive);
        new Clipper((SnapshotView)this.getSkinnable(), (Node)this.unselectedArea, () -> this.unselectedArea.visibleProperty().bind((ObservableValue)existsAndActive));
    }

    private void updateNode() {
        if (this.node != null) {
            this.gridPane.getChildren().remove((Object)this.node);
        }
        this.node = ((SnapshotView)this.getSkinnable()).getNode();
        if (this.node != null) {
            this.gridPane.getChildren().add(0, (Object)this.node);
        }
    }

    private void updateSelection() {
        boolean showSelection;
        boolean bl = showSelection = ((SnapshotView)this.getSkinnable()).hasSelection() && ((SnapshotView)this.getSkinnable()).isSelectionActive();
        if (showSelection) {
            Rectangle2D selection = ((SnapshotView)this.getSkinnable()).getSelection();
            this.setSelection(selection.getMinX(), selection.getMinY(), selection.getWidth(), selection.getHeight());
        } else {
            this.setSelection(0.0, 0.0, 0.0, 0.0);
        }
    }

    private void setSelection(double x, double y, double width, double height) {
        this.selectedArea.setX(x);
        this.selectedArea.setY(y);
        this.selectedArea.setWidth(width);
        this.selectedArea.setHeight(height);
    }

    private void handleMouseEvent(MouseEvent event) {
        Cursor newCursor = ((SnapshotViewBehavior)this.getBehavior()).handleMouseEvent(event);
        this.mouseNode.setCursor(newCursor);
    }

    private static class Clipper {
        private final SnapshotView snapshotView;
        private final Node clippedNode;
        private final Runnable rebindClippedNodeVisibility;
        private final Rectangle controlClip;
        private final Rectangle nodeClip;
        private final ChangeListener<Bounds> updateControlClipToNewBoundsListener;
        private final ChangeListener<Bounds> updateNodeClipToNewBoundsListener;

        public Clipper(SnapshotView snapshotView, Node clippedNode, Runnable rebindClippedNodeVisibility) {
            this.snapshotView = snapshotView;
            this.clippedNode = clippedNode;
            this.rebindClippedNodeVisibility = rebindClippedNodeVisibility;
            this.controlClip = new Rectangle();
            this.updateControlClipToNewBoundsListener = (o, oldBounds, newBounds) -> Clipper.resizeRectangleToBounds(this.controlClip, newBounds);
            this.nodeClip = new Rectangle();
            this.updateNodeClipToNewBoundsListener = (o, oldBounds, newBounds) -> Clipper.resizeRectangleToBounds(this.nodeClip, newBounds);
            this.setClipping();
            snapshotView.unselectedAreaBoundaryProperty().addListener((o, oldBoundary, newBoundary) -> this.setClipping());
        }

        private void setClipping() {
            SnapshotView.Boundary boundary = this.snapshotView.getUnselectedAreaBoundary();
            switch (boundary) {
                case CONTROL: {
                    this.clipToControl();
                    break;
                }
                case NODE: {
                    this.clipToNode();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The boundary " + (Object)((Object)boundary) + " is not fully implemented.");
                }
            }
        }

        private void clipToControl() {
            this.updateNodeClipToChangingNode((ObservableValue<? extends Node>)this.snapshotView.nodeProperty(), this.snapshotView.getNode(), null);
            Clipper.resizeRectangleToBounds(this.controlClip, this.snapshotView.getBoundsInLocal());
            this.snapshotView.boundsInLocalProperty().addListener(this.updateControlClipToNewBoundsListener);
            this.setClip((Node)this.controlClip);
        }

        private void clipToNode() {
            this.updateNodeClipToChangingNode((ObservableValue<? extends Node>)this.snapshotView.nodeProperty(), null, this.snapshotView.getNode());
            this.snapshotView.nodeProperty().addListener(this::updateNodeClipToChangingNode);
            this.setClip((Node)this.nodeClip);
        }

        private void updateNodeClipToChangingNode(ObservableValue<? extends Node> o, Node oldNode, Node newNode) {
            Clipper.resizeRectangleToNodeBounds(this.nodeClip, newNode);
            if (oldNode != null) {
                oldNode.boundsInParentProperty().removeListener(this.updateNodeClipToNewBoundsListener);
            }
            if (newNode != null) {
                newNode.boundsInParentProperty().addListener(this.updateNodeClipToNewBoundsListener);
            }
        }

        private static void resizeRectangleToNodeBounds(Rectangle rectangle, Node node) {
            if (node == null) {
                Clipper.resizeRectangleToZero(rectangle);
            } else {
                Clipper.resizeRectangleToBounds(rectangle, node.getBoundsInParent());
            }
        }

        private static void resizeRectangleToZero(Rectangle rectangle) {
            rectangle.setX(0.0);
            rectangle.setY(0.0);
            rectangle.setWidth(0.0);
            rectangle.setHeight(0.0);
        }

        private static void resizeRectangleToBounds(Rectangle rectangle, Bounds bounds) {
            rectangle.setX(bounds.getMinX());
            rectangle.setY(bounds.getMinY());
            rectangle.setWidth(bounds.getWidth());
            rectangle.setHeight(bounds.getHeight());
        }

        private void setClip(Node clip) {
            boolean workAroundVisibilityProblem;
            boolean bl = workAroundVisibilityProblem = !this.clippedNode.isVisible();
            if (workAroundVisibilityProblem) {
                this.clippedNode.visibleProperty().unbind();
                this.clippedNode.setVisible(true);
            }
            this.clippedNode.setClip(clip);
            if (workAroundVisibilityProblem) {
                this.rebindClippedNodeVisibility.run();
            }
        }
    }
}

