/*
 * Decompiled with CFR 0.152.
 */
package DVE.evaluation;

import DVE.compiler.builder.DVEBuilder;
import DVE.model.ArrayLiteral;
import DVE.model.BinaryExpression;
import DVE.model.Expression;
import DVE.model.IndexedExpression;
import DVE.model.Literal;
import DVE.model.NumberLiteral;
import DVE.model.UnaryExpression;
import DVE.model.VariableReference;
import DVE.model.util.ModelSwitch;
import java.math.BigInteger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class StaticEvaluator {
    DVEBuilder builder = DVEBuilder.uniqueInstance;
    ModelSwitch<Literal> modelSwitch = new ModelSwitch<Literal>(){

        @Override
        public Literal caseUnaryExpression(UnaryExpression object) {
            NumberLiteral lit = (NumberLiteral)this.doSwitch(object.getOperand());
            switch (object.getOperator()) {
                case BNOT: {
                    return StaticEvaluator.this.builder.literal(lit.getValue().not());
                }
                case MINUS: {
                    return StaticEvaluator.this.builder.literal(lit.getValue().negate());
                }
                case NOT: {
                    return StaticEvaluator.this.builder.literal(lit.getValue().equals(BigInteger.ZERO) ? 1 : 0);
                }
            }
            return null;
        }

        @Override
        public Literal caseBinaryExpression(BinaryExpression object) {
            NumberLiteral lhs = (NumberLiteral)this.doSwitch((EObject)object.getOperands().get(0));
            NumberLiteral rhs = (NumberLiteral)this.doSwitch((EObject)object.getOperands().get(1));
            BigInteger lhsV = lhs.getValue();
            BigInteger rhsV = rhs.getValue();
            boolean lhsIsTrue = !lhsV.equals(BigInteger.ZERO);
            boolean rhsIsTrue = !rhsV.equals(BigInteger.ZERO);
            switch (object.getOperator()) {
                case AND: {
                    return StaticEvaluator.this.builder.literal(lhsIsTrue && rhsIsTrue);
                }
                case BAND: {
                    return StaticEvaluator.this.builder.literal(lhsV.and(rhsV));
                }
                case BOR: {
                    return StaticEvaluator.this.builder.literal(lhsV.or(rhsV));
                }
                case BXOR: {
                    return StaticEvaluator.this.builder.literal(lhsV.xor(rhsV));
                }
                case DIV: {
                    return StaticEvaluator.this.builder.literal(lhsV.divide(rhsV));
                }
                case EQ: {
                    return StaticEvaluator.this.builder.literal(lhsV.compareTo(rhsV) == 0);
                }
                case GEQ: {
                    return StaticEvaluator.this.builder.literal(lhsV.compareTo(rhsV) >= 0);
                }
                case GT: {
                    return StaticEvaluator.this.builder.literal(lhsV.compareTo(rhsV) > 0);
                }
                case IMPLY: {
                    break;
                }
                case LEQ: {
                    return StaticEvaluator.this.builder.literal(lhsV.compareTo(rhsV) <= 0);
                }
                case LT: {
                    return StaticEvaluator.this.builder.literal(lhsV.compareTo(rhsV) < 0);
                }
                case MINUS: {
                    return StaticEvaluator.this.builder.literal(lhsV.subtract(rhsV));
                }
                case MOD: {
                    return StaticEvaluator.this.builder.literal(lhsV.mod(rhsV));
                }
                case MULT: {
                    return StaticEvaluator.this.builder.literal(lhsV.multiply(rhsV));
                }
                case NEQ: {
                    return StaticEvaluator.this.builder.literal(lhsV.compareTo(rhsV) != 0);
                }
                case OR: {
                    return StaticEvaluator.this.builder.literal(lhsIsTrue || rhsIsTrue);
                }
                case PLUS: {
                    return StaticEvaluator.this.builder.literal(lhsV.add(rhsV));
                }
                case SHL: {
                    return StaticEvaluator.this.builder.literal(lhsV.shiftLeft(rhsV.intValue()));
                }
                case SHR: {
                    return StaticEvaluator.this.builder.literal(lhsV.shiftRight(rhsV.intValue()));
                }
            }
            return null;
        }

        @Override
        public Literal caseVariableReference(VariableReference object) {
            return (Literal)this.doSwitch(object.getRef().getInitial());
        }

        @Override
        public Literal caseIndexedExpression(IndexedExpression object) {
            NumberLiteral idx = (NumberLiteral)this.doSwitch(object.getIndex());
            ArrayLiteral aL = (ArrayLiteral)this.doSwitch(object.getBase());
            return (Literal)this.doSwitch((EObject)aL.getValues().get(idx.getValue().intValue()));
        }

        @Override
        public Literal caseArrayLiteral(ArrayLiteral object) {
            EList<Expression> exps = object.getValues();
            for (int idx = 0; idx < exps.size(); ++idx) {
                Literal lit = (Literal)this.doSwitch((EObject)exps.get(idx));
                exps.set(idx, lit);
            }
            return object;
        }

        @Override
        public Literal caseLiteral(Literal object) {
            return object;
        }

        @Override
        public Literal caseExpression(Expression object) {
            System.err.println("the object is not a static expression");
            return null;
        }
    };
    static StaticEvaluator uniqueInstance = new StaticEvaluator();

    public Literal eval(Expression exp) {
        return (Literal)this.modelSwitch.doSwitch(exp);
    }

    public static Literal evaluate(Expression exp) {
        return uniqueInstance.eval(exp);
    }
}

