/*
 * Decompiled with CFR 0.152.
 */
package plug.language.SpinJa.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import spinja.promela.compiler.Proctype;
import spinja.promela.compiler.Specification;
import spinja.promela.compiler.optimizer.GraphOptimizer;
import spinja.promela.compiler.optimizer.RemoveUselessActions;
import spinja.promela.compiler.optimizer.RemoveUselessGotos;
import spinja.promela.compiler.optimizer.RenumberAll;
import spinja.promela.compiler.optimizer.StateMerging;
import spinja.promela.compiler.parser.ParseException;
import spinja.promela.compiler.parser.Promela;

public class SpinJaCompiler {
    public static Specification compile(File promFile, String name, boolean useStateMerging, boolean verbose) {
        try {
            if (verbose) {
                System.out.print("Start parsing " + promFile.getName() + "...");
            }
            Promela prom = new Promela((InputStream)new FileInputStream(promFile));
            Specification spec = prom.spec(name);
            if (verbose) {
                System.out.println("done");
            }
            if (verbose) {
                System.out.println("Optimizing graphs...");
            }
            GraphOptimizer[] optimizers = new GraphOptimizer[]{useStateMerging ? new StateMerging() : null, new RemoveUselessActions(), new RemoveUselessGotos(), new RenumberAll()};
            for (Proctype proc : spec) {
                if (verbose) {
                    System.out.println("Initial graph for process " + proc + ":");
                    System.out.println(proc.getAutomaton());
                }
                GraphOptimizer[] graphOptimizerArray = optimizers;
                int n = graphOptimizerArray.length;
                for (int i = 0; i < n; ++i) {
                    GraphOptimizer opt = graphOptimizerArray[i];
                    if (opt == null) continue;
                    opt.optimize(proc.getAutomaton());
                    if (!verbose) continue;
                    System.out.println("After " + opt.getClass().getSimpleName() + ":");
                    System.out.println(proc.getAutomaton());
                }
                if (!verbose) continue;
                System.out.println(proc.getAutomaton());
            }
            Proctype never = spec.getNever();
            if (never != null) {
                if (verbose) {
                    System.out.println("Initial graph for never claim:");
                    System.out.println(never.getAutomaton());
                }
                for (GraphOptimizer opt : optimizers) {
                    if (opt != null) {
                        opt.optimize(never.getAutomaton());
                    }
                    if (!verbose) continue;
                    System.out.println("After " + opt.getClass().getSimpleName() + ":");
                    System.out.println(never.getAutomaton());
                }
                if (verbose) {
                    System.out.println(never.getAutomaton());
                }
            }
            if (verbose) {
                System.out.println("Optimization done");
            }
            return spec;
        }
        catch (FileNotFoundException ex) {
            System.out.println("Promela file " + promFile.getName() + " could not be found.");
        }
        catch (ParseException ex) {
            System.out.println("Parse exception in file " + promFile.getName() + ": " + ex.getMessage());
        }
        return null;
    }
}

