/*
 * Decompiled with CFR 0.152.
 */
package spinja.promela.model;

import spinja.exceptions.ValidationException;
import spinja.promela.exceptions.TooManyChannelsException;
import spinja.promela.exceptions.TooManyProcessesException;
import spinja.promela.model.Channel;
import spinja.promela.model.PromelaProcess;
import spinja.promela.model.PromelaTransition;
import spinja.promela.model.PromelaTransitionFactory;

public class EndTransitionFactory
extends PromelaTransitionFactory {
    public EndTransitionFactory(int n) {
        super(true, n, 0, 0, "-end-");
    }

    @Override
    public final boolean isEnabled() {
        return this.state.proc._model._nrProcs == this.state.proc._pid + 1;
    }

    @Override
    public PromelaTransition newTransition() {
        return new PromelaTransition(){
            private Channel[] _backup_channels;

            @Override
            public PromelaTransitionFactory getFactory() {
                return EndTransitionFactory.this;
            }

            @Override
            public PromelaProcess getProcess() {
                return EndTransitionFactory.this.getState().getProcess();
            }

            @Override
            public boolean isEnabled() {
                return EndTransitionFactory.this.isEnabled();
            }

            @Override
            public boolean isLocal() {
                return true;
            }

            @Override
            public int getId() {
                return EndTransitionFactory.this.transId;
            }

            @Override
            public void take() throws ValidationException {
                this._backup_channels = this.getProcess()._model.endProcess();
                this.getProcess().sendTransitionTakenEvent(this);
            }

            @Override
            public void undo() {
                try {
                    this.getProcess()._model.addProcess(this.getProcess());
                    if (this._backup_channels != null) {
                        for (Channel channel : this._backup_channels) {
                            this.getProcess()._model.addChannel(channel);
                        }
                    }
                }
                catch (TooManyProcessesException tooManyProcessesException) {
                    throw new Error("Can not restore model, too many processes.");
                }
                catch (TooManyChannelsException tooManyChannelsException) {
                    throw new Error("Can not restore model, too many channels.");
                }
                this.getProcess().sendTransitionUndoEvent(this);
            }

            public String toString() {
                return "-end-";
            }
        };
    }
}

