/*
 * Decompiled with CFR 0.152.
 */
package obp.ui.tina;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import obp.aut.LTSDotPrinter;
import obp.cdl.CDLDeclaration;
import obp.dot.Graph;
import obp.dot.util.DotUtil;
import obp.tina.OBPtConfiguration;
import obp.tina.SeltResult;
import obp.tina.TinaController;
import obp.ui.cdl.CDLUnitController;
import obp.ui.dot.diagram.GraphDiagram;
import obp.ui.fiacre.ProgramController;
import obp.ui.tina.Actions;
import obp.ui.tina.Resources;
import obp.ui.tina.TinaModel;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.xid.basics.Basics;
import org.xid.basics.error.Diagnostic;
import org.xid.basics.error.DiagnosticUtil;
import org.xid.basics.error.ErrorHandler;
import org.xid.basics.error.NumberValidator;
import org.xid.basics.error.Validator;
import org.xid.basics.notification.Notification;
import org.xid.basics.notification.NotificationListener;
import org.xid.basics.progress.ActionMonitor;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.JBoost;
import org.xid.basics.ui.PlatformUtil;
import org.xid.basics.ui.action.Action;
import org.xid.basics.ui.action.ActionExecuter;
import org.xid.basics.ui.diagram.Diagram;
import org.xid.basics.ui.dialog.FieldShellToolkit;
import org.xid.basics.ui.field.BorderField;
import org.xid.basics.ui.field.CheckboxField;
import org.xid.basics.ui.field.ChoiceField;
import org.xid.basics.ui.field.CompositeField;
import org.xid.basics.ui.field.ConsoleField;
import org.xid.basics.ui.field.DiagramField;
import org.xid.basics.ui.field.Field;
import org.xid.basics.ui.field.ListField;
import org.xid.basics.ui.field.MultiTabField;
import org.xid.basics.ui.field.TextField;

public class OBPt {
    private String version;
    private String date;
    private final DateFormat dateFormat = SimpleDateFormat.getDateTimeInstance();
    private Display display;
    private Shell shell;
    private FieldShellToolkit toolkit;
    private Actions actions;
    private Resources resources;
    private BorderField shellField;
    private MultiTabField centerField;
    private TextField cdlFileField;
    private ChoiceField<CDLDeclaration> cdlChoiceField;
    private CheckboxField cdlPartitionField;
    private TextField cdlInitialSplitField;
    private TextField cdlSplitStepField;
    private TextField cdlInfoTextField;
    private CompositeField cdlFileComposite;
    private ListField<File> programFileField;
    private TextField formulasFileField;
    private CDLUnitController cdlController;
    private ProgramController programController;
    private TextField formulaField;
    private ListField<SeltResult> diagnosticField;
    private TextField diagnosticInfoField;
    private DiagramField<Graph> counterExampleField;
    private MultiTabField southField;
    private ConsoleField resultsField;
    private CompositeField resultsCompositeField;
    private ConsoleField consoleField;
    private CompositeField consoleCompositeField;
    private OBPtConfiguration configuration = null;
    private TinaController tinaController = null;
    private boolean explored = false;
    private boolean working = false;
    private boolean cdlWorking = false;
    private ActionExecuter executer = new ActionExecuter(){

        public void executeAction(Action action) {
            int status = action.run(ActionMonitor.empty);
            if (status == 1 && !OBPt.this.shell.isDisposed()) {
                OBPt.this.display.asyncExec(OBPt.this.refreshRunnable);
            }
        }
    };
    private Runnable refreshRunnable = new Runnable(){

        @Override
        public void run() {
            OBPt.this.refreshFields();
            OBPt.this.consoleField.scrollToTheEnd();
        }
    };
    private ErrorHandler errorHandler = new ErrorHandler(){

        public void handleError(int type, String message) {
            this.handleError((Diagnostic)new Diagnostic.Stub(type, message));
        }

        public void handleError(Diagnostic diagnostic) {
            switch (diagnostic.getLevel()) {
                case 0: {
                    OBPt.this.log(diagnostic.getMessage());
                    break;
                }
                case 1: {
                    OBPt.this.warning(diagnostic.getMessage());
                    break;
                }
                case 2: {
                    OBPt.this.error(diagnostic.getMessage());
                }
            }
        }
    };
    private final TinaModel model = new TinaModel(this);

    public TinaModel getModel() {
        return this.model;
    }

    public OBPtConfiguration getConfiguration() {
        return this.configuration;
    }

    public Shell getShell() {
        return this.shell;
    }

    public Resources getResources() {
        return this.resources;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    private File getConfigurationFile() {
        return new File(System.getProperty("user.home"), ".OBPt.conf");
    }

    private JBoost createTinaConfigurationBoost() {
        return new JBoost("OBPtConf", 1);
    }

    private void saveConfiguration() {
        try {
            JBoost boost = this.createTinaConfigurationBoost();
            boost.initializeWriting((OutputStream)new FileOutputStream(this.getConfigurationFile()));
            boost.writeObject((BoostObject)this.configuration);
            boost.close();
        }
        catch (Exception e) {
            this.log("Can't save configuration to file '" + this.getConfigurationFile().getAbsolutePath() + "'.");
        }
    }

    private void initVersion() {
        try {
            Properties properties = new Properties();
            properties.load(this.getClass().getResourceAsStream("version.properties"));
            this.version = properties.getProperty("version");
            this.date = properties.getProperty("date");
        }
        catch (Exception e) {
            this.warning(DiagnosticUtil.createMessage((Throwable)e));
            this.version = "unknown";
            this.date = "unknown";
        }
    }

    private void initTina() {
        try {
            JBoost boost = this.createTinaConfigurationBoost();
            boost.initializeReading((InputStream)new FileInputStream(this.getConfigurationFile()));
            this.configuration = (OBPtConfiguration)boost.readObject(OBPtConfiguration.class);
            boost.close();
        }
        catch (Exception e) {
            this.configuration = new OBPtConfiguration();
        }
        this.tinaController = new TinaController(this.configuration, this.consoleField.createPrintWriter(2, 0), this.consoleField.createPrintWriter(4, 1));
        this.tinaController.setAnalyseSource(true);
        this.tinaController.setErrorHandler(this.errorHandler);
    }

    public void open() {
        this.initVersion();
        this.display = new Display();
        this.resources = (Resources)Resources.getInstance(Resources.class);
        this.actions = new Actions(this);
        this.shell = FieldShellToolkit.createShell((Display)this.display, (String)"OBPt");
        this.toolkit = new FieldShellToolkit(this.shell, this.getVersionString(), 1, this.createFields());
        this.toolkit.setBannerImage(this.resources.getImage("obp100x66.png"));
        this.toolkit.setActionExecuter(this.executer);
        this.toolkit.setMenuActions(this.actions.getMenuAction().getActions());
        this.toolkit.init();
        PlatformUtil.registerCocoaNameAboutAndPreference((String)"OBPt", (Action)new Action.Stub(), (Action)this.actions.getPreferencesAction());
        this.initTina();
        this.refreshFields();
        this.toolkit.validateAll();
        this.installActivateListener();
        this.shell.setSize(800, 650);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            try {
                if (this.display.readAndDispatch()) continue;
                this.display.sleep();
            }
            catch (Throwable e) {
                this.error(DiagnosticUtil.createMessage((Throwable)e));
            }
        }
        this.dispose();
        System.exit(0);
    }

    public void installActivateListener() {
        this.shell.addListener(26, new Listener(){

            public void handleEvent(Event event) {
                OBPt.this.model.reloadFilesIfNeeded();
            }
        });
    }

    private Field createFields() {
        this.centerField = new MultiTabField(null, 64);
        this.cdlFileField = new TextField("File", 1);
        this.cdlFileField.addAction(this.actions.getOpenCdlFileAction(this.cdlFileField));
        this.cdlChoiceField = new ChoiceField<CDLDeclaration>("CDL", 2){

            public String getText(CDLDeclaration element) {
                return element.getName();
            }
        };
        this.cdlChoiceField.addListener(new NotificationListener(){

            public void notified(Notification notification) {
                if (notification.type == 1 && "value".equals(notification.name)) {
                    OBPt.this.model.setCdl((CDLDeclaration)OBPt.this.cdlChoiceField.getValue());
                    OBPt.this.refreshFilesFields();
                }
            }
        });
        this.cdlPartitionField = new CheckboxField("Partition");
        this.cdlPartitionField.setValue(this.model.isAutoPartition());
        this.cdlPartitionField.addListener(new NotificationListener(){

            public void notified(Notification notification) {
                if (notification.type == 1 && "value".equals(notification.name)) {
                    OBPt.this.model.setAutoPartition(OBPt.this.cdlPartitionField.getValue());
                    OBPt.this.refreshFilesFields();
                }
            }
        });
        this.cdlInitialSplitField = new TextField("Initial Split");
        this.cdlInitialSplitField.setEnable(this.model.isAutoPartition());
        this.cdlInitialSplitField.setValidator((Validator)new NumberValidator(2, "Invalid split parameter", Basics.NOT_ZERO));
        this.cdlInitialSplitField.addListener(new NotificationListener(){

            public void notified(Notification notification) {
                if (notification.type == 1 && "value".equals(notification.name) && OBPt.this.cdlInitialSplitField.getIntValue() > 0) {
                    OBPt.this.model.setInitialStep(OBPt.this.cdlInitialSplitField.getIntValue());
                    OBPt.this.refreshFilesFields();
                }
            }
        });
        this.cdlSplitStepField = new TextField("Split step");
        this.cdlSplitStepField.setEnable(this.model.isAutoPartition());
        this.cdlSplitStepField.setValidator((Validator)new NumberValidator(2, "Invalid split parameter", Basics.NOT_ZERO));
        this.cdlSplitStepField.addListener(new NotificationListener(){

            public void notified(Notification notification) {
                if (notification.type == 1 && "value".equals(notification.name) && OBPt.this.cdlSplitStepField.getIntValue() > 0) {
                    OBPt.this.model.setSplitStep(OBPt.this.cdlSplitStepField.getIntValue());
                    OBPt.this.refreshFilesFields();
                }
            }
        });
        CompositeField cdlPartitionCompositeField = new CompositeField("Partition", 16, new Field[]{this.cdlPartitionField, this.cdlInitialSplitField, this.cdlSplitStepField});
        this.cdlInfoTextField = new TextField(null, 1);
        this.cdlInfoTextField.setNbLines(2);
        this.cdlInfoTextField.addAction((Action)new Action.Stub("Refresh"){

            public int getVisibility() {
                return OBPt.this.cdlWorking ? 2 : 1;
            }

            public int run(ActionMonitor monitor) {
                OBPt.this.cdlWorking = true;
                OBPt.this.display.asyncExec(OBPt.this.refreshRunnable);
                OBPt.this.model.computeCdlInfo((ActionMonitor)new ActionMonitor.Stub(){

                    public void done() {
                        OBPt.this.cdlWorking = false;
                        OBPt.this.display.asyncExec(OBPt.this.refreshRunnable);
                    }

                    public void canceled() {
                        OBPt.this.cdlWorking = false;
                        OBPt.this.display.asyncExec(OBPt.this.refreshRunnable);
                    }
                });
                return 1;
            }
        });
        this.cdlInfoTextField.addAction((Action)new Action.Stub("Stop"){

            public int getVisibility() {
                return OBPt.this.model.isComputingCdlInformation() ? 1 : 2;
            }

            public int run(ActionMonitor monitor) {
                OBPt.this.model.stopComputingCdlInformation();
                return 1;
            }
        });
        CompositeField cdlInfoCompositeField = new CompositeField("Informations", 16, new Field[]{this.cdlInfoTextField});
        BorderField cdlChoiceBorderField = new BorderField(0, this.cdlChoiceField);
        cdlChoiceBorderField.setEast((Field)this.cdlFileField, 70);
        CompositeField cdlChoiceCompositeField = new CompositeField("Choice", 16, new Field[]{cdlChoiceBorderField});
        BorderField cdlBorderField = new BorderField(0, (Field)cdlPartitionCompositeField);
        cdlBorderField.setNorth((Field)cdlChoiceCompositeField, 35);
        cdlBorderField.setEast((Field)cdlInfoCompositeField, 70);
        this.cdlFileComposite = new CompositeField("CDLs", 16, new Field[]{cdlBorderField});
        this.programFileField = new ListField<File>("Files", 3){

            public String getText(File element) {
                return element.getAbsolutePath();
            }
        };
        this.programFileField.addAction(this.actions.getAddProgramAction(this.programFileField));
        this.programFileField.addAction(this.actions.getRemoveProgramAction(this.programFileField));
        this.programFileField.addAction(this.actions.getUpProgramAction(this.programFileField));
        this.programFileField.addAction(this.actions.getDownProgramAction(this.programFileField));
        this.programFileField.addAction(this.actions.getClearProgramListAction(this.programFileField));
        CompositeField programFileComposite = new CompositeField("Program", 16, new Field[]{this.programFileField});
        this.formulasFileField = new TextField("File", 3);
        this.formulasFileField.addAction(this.actions.getOpenFormulaAction(this.formulasFileField));
        CompositeField formulasFileComposite = new CompositeField("Formulas", 16, new Field[]{this.formulasFileField});
        BorderField filesBorderField = new BorderField(0, (Field)programFileComposite);
        filesBorderField.setNorth((Field)this.cdlFileComposite, 50);
        filesBorderField.setSouth((Field)formulasFileComposite, 12);
        CompositeField filesCompositeField = new CompositeField("Files", new Field[]{filesBorderField});
        this.centerField.addTab((Field)filesCompositeField, null, false);
        this.cdlController = new CDLUnitController();
        CompositeField cdlControllerComposite = this.cdlController.createFields();
        cdlControllerComposite.addListener(this.cdlController.createListener(this.executer));
        CompositeField cdlCompositeField = new CompositeField("CDLs", new Field[]{cdlControllerComposite});
        this.centerField.addTab((Field)cdlCompositeField, null, false);
        this.programController = new ProgramController(this.errorHandler);
        CompositeField programControllerComposite = this.programController.createFields();
        programControllerComposite.addListener(this.programController.createListener(this.executer));
        CompositeField programCompositeField = new CompositeField("Program", new Field[]{programControllerComposite});
        this.centerField.addTab((Field)programCompositeField, null, false);
        this.formulaField = new TextField(null, 3);
        this.formulaField.setNbLines(10);
        CompositeField verifyCompositeField = new CompositeField("Formulas", new Field[]{this.formulaField});
        this.centerField.addTab((Field)verifyCompositeField, null, false);
        this.diagnosticField = new ListField<SeltResult>(null, 2){

            public String getText(SeltResult element) {
                StringBuilder text = new StringBuilder();
                text.append(String.valueOf(element.getIndex()));
                text.append("(");
                text.append(element.isVerified());
                text.append(")");
                return text.toString();
            }
        };
        this.diagnosticInfoField = new TextField(null, 3);
        this.counterExampleField = new DiagramField((Diagram)new GraphDiagram());
        this.diagnosticField.addListener(new NotificationListener(){

            public void notified(Notification notification) {
                if ("selection".equals(notification.name)) {
                    OBPt.this.refreshDiagnosticInfo();
                }
            }
        });
        CompositeField diagnosticCompositeField = new CompositeField(new Field[]{this.diagnosticInfoField, this.counterExampleField});
        BorderField diagnosticBorderField = new BorderField("Diagnostic", 2, (Field)diagnosticCompositeField);
        diagnosticBorderField.setWest(this.diagnosticField, 30);
        this.centerField.addTab((Field)diagnosticBorderField, null, false);
        this.centerField.addAction(this.actions.getExploreProgramAction());
        this.centerField.addAction(this.actions.getVerifyAction());
        this.centerField.addAction(this.actions.getSeparatorAction());
        this.centerField.addAction(this.actions.getStopAction());
        this.southField = new MultiTabField(null, 64);
        this.resultsField = new ConsoleField();
        this.resultsCompositeField = new CompositeField("Results", new Field[]{this.resultsField});
        this.southField.addTab((Field)this.resultsCompositeField, null, false);
        this.consoleField = new ConsoleField();
        this.consoleCompositeField = new CompositeField("Console", new Field[]{this.consoleField});
        this.southField.addTab((Field)this.consoleCompositeField, this.resources.getImage("eclipse/console_view.gif"), false);
        this.shellField = new BorderField(2, (Field)this.centerField);
        this.shellField.setSouth((Field)this.southField, 30);
        this.shellField.setActionExecuter(this.executer);
        return this.shellField;
    }

    public void refreshFields() {
        this.refreshFilesFields();
        this.refreshCdlFields();
        this.refreshProgramFields();
        this.refreshFormulasFields();
        this.refreshDiagnosticFields();
        this.refreshResults();
        this.toolkit.validateAll();
    }

    public void refreshFilesFields() {
        if (this.model.getCdlFile() != null) {
            this.cdlFileField.setValue(this.model.getCdlFile().getAbsolutePath());
        } else {
            this.cdlFileField.setValue("No CDL loaded.");
        }
        this.cdlChoiceField.setRange(this.model.getCdlList());
        this.cdlChoiceField.setValue((Object)this.model.getCdl());
        this.cdlFileComposite.setEnable(!this.cdlWorking);
        this.cdlPartitionField.setValue(this.model.isAutoPartition());
        this.cdlInitialSplitField.setIntValue(this.model.getInitialStep());
        this.cdlSplitStepField.setIntValue(this.model.getSplitStep());
        this.cdlInfoTextField.setValue(this.model.getCdlInfoDescription());
        this.programFileField.setValue(this.model.getProgramFileList());
        if (this.model.getFormulasFile() != null) {
            this.formulasFileField.setValue(this.model.getFormulasFile().getAbsolutePath());
        } else {
            this.formulasFileField.setValue("No formulas loaded.");
        }
    }

    public void refreshCdlFields() {
        this.cdlController.setSubject(this.model.getCdlUnit());
        this.cdlController.refreshFields();
    }

    public void refreshProgramFields() {
        this.programController.setSubject(this.model.getProgramSource());
        this.programController.refreshFields();
    }

    public void refreshFormulasFields() {
        this.formulaField.setValue(this.model.getFormulas());
    }

    public void refreshDiagnosticFields() {
        this.diagnosticField.setValue(this.model.getSeltResults());
    }

    private void refreshDiagnosticInfo() {
        SeltResult result = (SeltResult)this.diagnosticField.getSingleSelection();
        if (result != null) {
            this.diagnosticInfoField.setValue(result.getInfo());
            if (result.isVerified()) {
                this.counterExampleField.setValue(null);
            } else {
                try {
                    Graph graph = DotUtil.layoutDot(LTSDotPrinter.toDot(result.getAut(), result.getStates()));
                    this.counterExampleField.setValue((Object)graph);
                }
                catch (Exception e) {
                    this.error(DiagnosticUtil.createMessage((Throwable)e));
                }
            }
        } else {
            this.diagnosticInfoField.setValue("No info");
        }
    }

    public void refreshResults() {
        this.resultsField.clear();
        this.resultsField.log(this.model.getResultDescription());
    }

    private void dispose() {
        Resources.releaseInstance(Resources.class);
        this.tinaController.stop();
        this.saveConfiguration();
    }

    public boolean isWorking() {
        return this.working;
    }

    public boolean isCdlWorking() {
        return this.cdlWorking;
    }

    public boolean isExplored() {
        return this.explored;
    }

    public void setExplored(boolean explored) {
        this.explored = explored;
    }

    public boolean hasError() {
        return this.shellField.getDiagnostic() != null;
    }

    public boolean canExplore() {
        boolean result = !this.hasError();
        result &= !this.working;
        return result &= this.model.getExplorableProgramFile() != null;
    }

    public boolean canShowExploration() {
        return !this.hasError() && this.isExplored();
    }

    public boolean canVerify() {
        return !this.hasError() && this.isExplored() && !this.working && this.model.getFormulasFile() != null;
    }

    public void explore() {
        if (!this.canExplore()) {
            return;
        }
        this.working = true;
        this.explored = false;
        Date start = new Date();
        this.log("[Explore, started at " + this.dateFormat.format(start) + "]\n");
        this.model.explore(this.tinaController, (ActionMonitor)new ActionMonitor.Stub(){

            public void done() {
                Date end = new Date();
                OBPt.this.log("[Explore, ended at " + OBPt.this.dateFormat.format(end) + "]\n");
                OBPt.this.working = false;
                OBPt.this.explored = true;
                OBPt.this.display.asyncExec(OBPt.this.refreshRunnable);
            }

            public void canceled() {
                Date end = new Date();
                OBPt.this.log("[Explore, canceled at " + OBPt.this.dateFormat.format(end) + "]\n");
                OBPt.this.working = false;
                OBPt.this.display.asyncExec(OBPt.this.refreshRunnable);
            }
        });
    }

    public void showExplorationGraph() {
        if (!this.isExplored()) {
            return;
        }
        this.working = true;
        this.tinaController.extractExplorationGraph(this.isUseDescription(), (ActionMonitor)new ActionMonitor.Stub(){

            public void done() {
                OBPt.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DiagramField graphField = new DiagramField((Diagram)new GraphDiagram());
                        Graph explorationGraph = OBPt.this.tinaController.popResult(Graph.class);
                        graphField.setValue((Object)explorationGraph);
                        Shell graphShell = new Shell(OBPt.this.display, 1264);
                        graphShell.setText("OBPt: Graph");
                        graphField.addAction(graphField.getController().createIncreaseZoomAction());
                        graphField.addAction(graphField.getController().createDecreaseZoomAction());
                        FieldShellToolkit graphToolkit = new FieldShellToolkit(graphShell, "", 4, (Field)graphField);
                        graphToolkit.init();
                        graphShell.setSize(400, 400);
                        graphShell.open();
                    }
                });
                OBPt.this.working = false;
                OBPt.this.display.asyncExec(OBPt.this.refreshRunnable);
            }

            public void canceled() {
                OBPt.this.working = false;
                OBPt.this.display.asyncExec(OBPt.this.refreshRunnable);
            }
        });
    }

    public void showExplorationResult() {
        if (!this.isExplored()) {
            return;
        }
        this.working = true;
        this.tinaController.ktzio(null, (ActionMonitor)new ActionMonitor.Stub(){

            public void done() {
                OBPt.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell textShell = new Shell(OBPt.this.display, 1264);
                        textShell.setText("OBPt: Result");
                        textShell.setSize(600, 600);
                        textShell.setLayout((Layout)new FillLayout());
                        Text text = new Text((Composite)textShell, 776);
                        text.setText(OBPt.this.tinaController.popResult(String.class));
                        textShell.open();
                    }
                });
                OBPt.this.working = false;
                OBPt.this.display.asyncExec(OBPt.this.refreshRunnable);
            }
        });
    }

    public void verify() {
        if (!this.canVerify()) {
            return;
        }
        Date start = new Date();
        this.log("[Verify, started at " + this.dateFormat.format(start) + "]\n");
        this.working = true;
        this.model.check(this.tinaController, (ActionMonitor)new ActionMonitor.Stub(){

            public void done() {
                Date end = new Date();
                OBPt.this.log("[Verify, ended at " + OBPt.this.dateFormat.format(end) + "]\n");
                OBPt.this.working = false;
                OBPt.this.display.asyncExec(OBPt.this.refreshRunnable);
            }

            public void canceled() {
                Date end = new Date();
                OBPt.this.log("[Verify, canceled at " + OBPt.this.dateFormat.format(end) + "]\n");
                OBPt.this.working = false;
                OBPt.this.display.asyncExec(OBPt.this.refreshRunnable);
            }
        });
    }

    public void stopCurrentAction() {
        if (!this.isWorking()) {
            return;
        }
        this.tinaController.interrupt();
        this.working = false;
    }

    public void showProgramSource(boolean show) {
        this.programController.showProgramSource(show);
    }

    public boolean isUseDescription() {
        return this.programController.isUseDescription();
    }

    public void setUseDescription(boolean useDescription) {
        this.programController.setUseDescription(useDescription);
    }

    public boolean isShowPogramSource() {
        return this.programController.isShowPogramSource();
    }

    public String getVersionString() {
        return "OBPt version " + this.version + " (" + this.date + ").\n";
    }

    public void log(final String message) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                OBPt.this.consoleField.log(message);
            }
        });
    }

    public void warning(final String message) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                OBPt.this.consoleField.log(message, 8, 2);
                OBPt.this.southField.setSelected((Field)OBPt.this.consoleCompositeField);
            }
        });
    }

    public void error(final String message) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                OBPt.this.consoleField.log(message, 4, 1);
                OBPt.this.southField.setSelected((Field)OBPt.this.consoleCompositeField);
            }
        });
    }

    public void clearConsole() {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                OBPt.this.consoleField.clear();
            }
        });
    }

    public static void main(String[] args) {
        new OBPt().open();
    }
}

