/*
 * Decompiled with CFR 0.152.
 */
package spinja.promela.compiler.automaton;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import spinja.promela.compiler.Proctype;
import spinja.promela.compiler.automaton.State;
import spinja.promela.compiler.automaton.Transition;
import spinja.promela.compiler.parser.ParseException;
import spinja.util.StringWriter;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class Automaton
implements Iterable<State> {
    private State startState;
    private final Proctype proctype;

    public Automaton(Proctype proctype) {
        this.proctype = proctype;
        this.startState = new State(this, false);
    }

    public void generateTable(StringWriter stringWriter) throws ParseException {
        assert (stringWriter != null);
        stringWriter.appendLine("PromelaTransitionFactory factory;");
        for (State state : this) {
            stringWriter.setSavePoint();
            int n = 0;
            for (Transition transition : state.output) {
                if (n == 0) {
                    stringWriter.appendLine("factory = ");
                } else {
                    stringWriter.appendLine("factory.append(");
                }
                stringWriter.indent();
                transition.printTransition(stringWriter);
                stringWriter.outdent();
                stringWriter.removePostfix().append(n == 0 ? ";" : ");").appendPostfix();
                ++n;
            }
            if (n == 0) {
                stringWriter.appendLine("factory = null;");
            }
            stringWriter.appendLine("_stateTable[", state.getStateId(), "] = new State(", this.getProctype().getName(), ".this, factory, ", state.isEndingState(), ", ", state.isProgressState(), ", ", state.isAcceptState(), ");");
            stringWriter.appendLine(new Object[0]);
        }
    }

    public Proctype getProctype() {
        return this.proctype;
    }

    public State getStartState() {
        return this.startState;
    }

    public void setStartState(State state) {
        if (state.getAutomaton() != this) {
            throw new IllegalArgumentException("The state must belong to this automaton!");
        }
        this.startState = state;
    }

    public boolean hasAtomic() {
        for (State state : this) {
            if (!state.isInAtomic()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<State> iterator() {
        return new Iterator<State>(){
            private Stack<State> stack = null;
            private final Set<State> done = new HashSet<State>();

            private void findNext(State state) {
                if (this.stack.isEmpty()) {
                    return;
                }
                State state2 = null;
                for (Transition transition : this.stack.peek().output) {
                    if (state != null) {
                        if (state != transition.getTo()) continue;
                        state = null;
                        continue;
                    }
                    if (this.done.contains(transition.getTo())) continue;
                    state2 = transition.getTo();
                    break;
                }
                if (state2 == null) {
                    this.findNext(this.stack.pop());
                } else {
                    this.done.add(state2);
                    this.stack.push(state2);
                }
            }

            @Override
            public boolean hasNext() {
                if (this.stack == null) {
                    this.done.add(Automaton.this.getStartState());
                    this.stack = new Stack();
                    this.stack.push(Automaton.this.getStartState());
                } else {
                    this.findNext(null);
                }
                return !this.stack.isEmpty();
            }

            @Override
            public State next() {
                return this.stack.peek();
            }

            @Override
            public void remove() {
                throw new NotImplementedException();
            }
        };
    }

    public int size() {
        int n = 0;
        for (State state : this) {
            ++n;
        }
        return n;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.appendLine("Graph for proctype ", this.proctype);
        stringWriter.indent();
        for (State state : this) {
            stringWriter.appendLine(state);
        }
        return stringWriter.toString();
    }
}

