/*
 * Decompiled with CFR 0.152.
 */
package plug.language.composition;

import java.util.ArrayList;
import java.util.List;
import plug.composite.CompositeAction;
import plug.composite.CompositeConfiguration;
import plug.composite.CompositeRuntime;
import plug.core.IConfiguration;
import plug.core.ILanguagePlugin;
import plug.core.IRuntimeView;
import plug.core.ITransitionRelation;
import plug.core.view.ConfigurationItem;

public class CompositionRuntimeView
implements IRuntimeView<CompositeConfiguration, CompositeRuntime.CompositeFireableTransition> {
    protected final CompositeRuntime runtime;
    protected final List<IRuntimeView> runtimeViews = new ArrayList<IRuntimeView>();

    public CompositionRuntimeView(CompositeRuntime runtime) {
        this.runtime = runtime;
        for (int i = 0; i < runtime.getRuntimeCount(); ++i) {
            ITransitionRelation componentRuntime = runtime.getRuntime(i);
            ILanguagePlugin componentModule = (ILanguagePlugin)runtime.runtimeToModule.get(componentRuntime);
            this.runtimeViews.add(componentModule.getRuntimeView(componentRuntime));
        }
    }

    public ITransitionRelation<CompositeConfiguration, CompositeRuntime.CompositeFireableTransition> getRuntime() {
        return this.runtime;
    }

    public List<ConfigurationItem> getConfigurationItems(CompositeConfiguration value) {
        ArrayList<ConfigurationItem> processes = new ArrayList<ConfigurationItem>();
        IConfiguration[] components = value.getComponents();
        for (int i = 0; i < components.length; ++i) {
            IConfiguration component = components[i];
            IRuntimeView runtimeView = this.runtimeViews.get(i);
            List children = runtimeView.getConfigurationItems((Object)component);
            ConfigurationItem processRoot = new ConfigurationItem("process", this.runtime.getRuntimeName(i), null, children);
            processes.add(processRoot);
        }
        return processes;
    }

    public String getFireableTransitionDescription(CompositeRuntime.CompositeFireableTransition transition) {
        IRuntimeView runtimeView = this.runtimeViews.get(transition.runtimeIndex);
        return runtimeView.getFireableTransitionDescription(transition.remote);
    }

    public String getActionDescription(Object action) {
        if (action instanceof CompositeAction) {
            CompositeAction compositeAction = (CompositeAction)action;
            int index = compositeAction.runtimeIndex;
            String name = this.runtime.getRuntimeName(index);
            return name + ": " + this.runtimeViews.get(index).getActionDescription(compositeAction.actions.get(0));
        }
        return action.toString();
    }
}

