/*
 * Decompiled with CFR 0.152.
 */
package plug.verifiers.observers;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import plug.composite.CompositeConfiguration;
import plug.core.IFiredTransition;
import plug.core.defaults.DefaultConfiguration;
import plug.statespace.transitions.FiredTransition;
import plug.verifiers.observers.IObserverAction;
import plug.verifiers.observers.IObserverRuntime;

public class SimpleObserverRuntime
implements IObserverRuntime {
    public int indexInConfiguration;
    public short initialState = 1;
    public final Map<BiPredicate<Short, CompositeConfiguration>, Short> observer = new LinkedHashMap<BiPredicate<Short, CompositeConfiguration>, Short>();

    @Override
    public void observeInitial(CompositeConfiguration configuration, Consumer<CompositeConfiguration> rejectHandler) {
        this.indexInConfiguration = configuration.add(new Config(this.initialState));
        FiredTransition<CompositeConfiguration, Object> f = new FiredTransition<CompositeConfiguration, Object>(configuration, configuration, null);
        this.observe(f, rejectHandler);
    }

    @Override
    public void observe(IFiredTransition<CompositeConfiguration, ?> observedTransition, Consumer<CompositeConfiguration> rejectHandler) {
        Config observerSource = this.getStateFrom(observedTransition.getSource());
        for (int i = 0; i < observedTransition.getTargets().size(); ++i) {
            IFiredTransition<Config, IObserverAction> fired = this.firedTransitionFrom(observerSource, observedTransition, i);
            if (fired == null) continue;
            this.update(observedTransition, i, fired);
            if (fired.getTarget((int)0).value != -1) continue;
            rejectHandler.accept(observedTransition.getTarget(i));
        }
    }

    Config getStateFrom(CompositeConfiguration observedSource) {
        return (Config)observedSource.get(this.indexInConfiguration);
    }

    void update(IFiredTransition<CompositeConfiguration, ?> observedTransition, int targetIndex, IFiredTransition<Config, IObserverAction> fired) {
        observedTransition.getTarget(targetIndex).set(this.indexInConfiguration, fired.getTarget(0));
    }

    IFiredTransition<Config, IObserverAction> firedTransitionFrom(Config observerSource, IFiredTransition<CompositeConfiguration, ?> observedTransition, int targetIndex) {
        for (Map.Entry<BiPredicate<Short, CompositeConfiguration>, Short> observerTransition : this.observer.entrySet()) {
            if (!observerTransition.getKey().test(observerSource.value, observedTransition.getTarget(targetIndex))) continue;
            Config target = new Config(observerTransition.getValue());
            return new FiredTransition<Config, Object>(observerSource, target, null);
        }
        return null;
    }

    static class Config
    extends DefaultConfiguration<Config> {
        short value;

        public Config(short value) {
            this.value = value;
        }

        public String toString() {
            return "{" + (this.value == -1 ? "REJECT" : Short.valueOf(this.value)) + "}";
        }

        @Override
        public Config createCopy() {
            return new Config(this.value);
        }

        @Override
        public int hashCode() {
            return this.value;
        }

        @Override
        public boolean equals(Object other) {
            return this.value == ((Config)other).value;
        }
    }
}

