/*
 * Decompiled with CFR 0.152.
 */
package plug.verifiers.observers;

import announce4j.Announcer;
import plug.composite.CompositeConfiguration;
import plug.core.IFiredTransition;
import plug.events.ExecutionStartedEvent;
import plug.events.FiredEvent;
import plug.verifiers.observers.IObserverRuntime;
import plug.verifiers.observers.RejectReachedEvent;

public class ObserverVerifier {
    public Announcer announcer = new Announcer(true);
    private IObserverRuntime observerRuntime;

    public ObserverVerifier(Announcer announcer, IObserverRuntime oR) {
        this.observerRuntime = oR;
        announcer.when(ExecutionStartedEvent.class, this::onExecutionStartedEvent);
        announcer.when(FiredEvent.class, this::onFiredEvent);
    }

    void onExecutionStartedEvent(Announcer ann, ExecutionStartedEvent<CompositeConfiguration> event) {
        try {
            for (CompositeConfiguration configuration : event.getInitialConfigurations()) {
                this.observerRuntime.observeInitial(configuration, this::rejectStateHandler);
            }
        }
        catch (ClassCastException e) {
            System.err.println("Do not forget to use the CompositeRuntime when verifying observers!");
            System.err.println("Try adding the runtime with 'addRuntime' instead of 'setRuntime'");
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    void onFiredEvent(Announcer ann, FiredEvent<CompositeConfiguration, ?> event) {
        IFiredTransition<CompositeConfiguration, ?> firedTransition = event.getFiredTransition();
        this.observerRuntime.observe(firedTransition, this::rejectStateHandler);
    }

    void rejectStateHandler(CompositeConfiguration configuration) {
        this.announcer.announce(new RejectReachedEvent<CompositeConfiguration>(configuration));
    }
}

