/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD.model.expressions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import org.cte.ABCD.ABCDVisitor;
import org.cte.ABCD.model.expressions.BinaryOperator;
import org.cte.ABCD.model.kernel.Expression;

public class BinaryExp
implements Expression {
    private final List<Expression> operandsList = new ArrayList<Expression>();
    private BinaryOperator operator;

    public List<Expression> getOperandsList() {
        return Collections.unmodifiableList(this.operandsList);
    }

    public int getOperandsCount() {
        return this.operandsList.size();
    }

    public Expression getOperands(int index) {
        if (index < 0 || index >= this.getOperandsCount()) {
            return null;
        }
        return this.operandsList.get(index);
    }

    public void addOperands(Expression newValue) {
        this.addOperands(this.getOperandsCount(), newValue);
    }

    public void addOperands(int index, Expression newValue) {
        this.operandsList.add(index, newValue);
    }

    public Expression setOperands(int index, Expression newValue) {
        return this.operandsList.set(index, newValue);
    }

    public void addAllOperands(Collection<Expression> toAddList) {
        for (Expression newValue : toAddList) {
            this.addOperands(this.getOperandsCount(), newValue);
        }
    }

    public void removeOperands(Expression value) {
        int index = this.operandsList.indexOf(value);
        if (index >= 0) {
            this.removeOperands(index);
        }
    }

    public void removeOperands(int index) {
        this.operandsList.remove(index);
    }

    public BinaryOperator getOperator() {
        return this.operator;
    }

    public void setOperator(BinaryOperator newValue) {
        if (this.operator == null ? newValue != null : !this.operator.equals((Object)newValue)) {
            this.operator = newValue;
        }
    }

    @Override
    public void accept(ABCDVisitor visitor) {
        visitor.visitBinaryExp(this);
    }

    public boolean equals(Object that) {
        return this.equalsCached(that, new IdentityHashMap<Object, Object>());
    }

    @Override
    public boolean equalsCached(Object that, IdentityHashMap<Object, Object> cache) {
        if (this == that) {
            cache.put(that, this);
            return true;
        }
        if (!(that instanceof BinaryExp)) {
            return false;
        }
        Object o1 = cache.get(this);
        if (o1 != null) {
            return o1 == that;
        }
        Object o2 = cache.get(that);
        if (o2 != null) {
            return o2 == this;
        }
        return this.equalsFeatures((BinaryExp)that, cache);
    }

    protected boolean equalsFeatures(BinaryExp that, IdentityHashMap<Object, Object> cache) {
        int l1size = 0;
        int l2size = 0;
        l1size = this.operandsList.size();
        if (l1size != (l2size = that.operandsList.size())) {
            return false;
        }
        for (int i = 0; i < l1size; ++i) {
            if (this.operandsList.get(i).equalsCached(that.operandsList.get(i), cache)) continue;
            return false;
        }
        return this.operator == that.operator;
    }
}

