/*
 * Decompiled with CFR 0.152.
 */
package obp.ui.tina;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import obp.ui.tina.OBPt;
import obp.ui.tina.OBPtConfigurationController;
import obp.ui.tina.TinaModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.FileDialog;
import org.xid.basics.Basics;
import org.xid.basics.error.DiagnosticUtil;
import org.xid.basics.generation.MergerUtil;
import org.xid.basics.progress.ActionMonitor;
import org.xid.basics.ui.action.Action;
import org.xid.basics.ui.controller.Controller;
import org.xid.basics.ui.dialog.FieldDialog;
import org.xid.basics.ui.field.ListField;
import org.xid.basics.ui.field.TextField;

public class Actions {
    private final OBPt ui;
    private final TinaModel model;
    private Action separatorAction;
    private Action menuAction;
    private Action fileAction;
    private Action openCdlFileAction;
    private Action openProgramFileAction;
    private Action openFormulasAction;
    private Action saveResultAction;
    private Action exportAction;
    private Action exportScrambledProgramAction;
    private Action exportLabelledProgramAction;
    private Action clearCdlAction;
    private Action clearProgramListAction;
    private Action clearFormulasAction;
    private Action preferencesAction;
    private Action quitAction;
    private Action programAction;
    private Action exploreProgramAction;
    private Action verifyAction;
    private Action stopAction;
    private Action viewAction;
    private Action showProgramSourceAction;
    private Action useDescriptionCommentAction;
    private Action showExplorationGraphAction;
    private Action showExplorationResultAction;
    private Action clearConsoleAction;

    public Actions(OBPt tinaUI) {
        this.ui = tinaUI;
        this.model = tinaUI.getModel();
    }

    public Action getSeparatorAction() {
        if (this.separatorAction == null) {
            this.separatorAction = new Action.Stub(27);
        }
        return this.separatorAction;
    }

    public Action getMenuAction() {
        if (this.menuAction == null) {
            this.menuAction = new Action.Container("Menu", new Action[]{this.getFileAction(), this.getProgramAction(), this.getViewAction()});
        }
        return this.menuAction;
    }

    public Action getFileAction() {
        if (this.fileAction == null) {
            this.fileAction = Basics.isMac() ? new Action.Container("File", new Action[]{this.getOpenCdlFileAction(), this.getOpenProgramAction(), this.getOpenFormulaAction(), this.getSeparatorAction(), this.getSaveResultAction(), this.getExportAction(), this.getSeparatorAction(), this.getClearCdlFileAction(), this.getClearProgramListAction(), this.getClearFormulasAction(), this.getPreferencesAction()}) : new Action.Container("File", new Action[]{this.getOpenCdlFileAction(), this.getOpenProgramAction(), this.getOpenFormulaAction(), this.getSeparatorAction(), this.getSaveResultAction(), this.getExportAction(), this.getSeparatorAction(), this.getClearCdlFileAction(), this.getClearProgramListAction(), this.getClearFormulasAction(), this.getSeparatorAction(), this.getPreferencesAction(), this.getSeparatorAction(), this.getQuitAction()});
        }
        return this.fileAction;
    }

    public Action getOpenCdlFileAction() {
        if (this.openCdlFileAction == null) {
            this.openCdlFileAction = new Action.Stub("Open CDL File\u2026", this.getImage("eclipse/open_edit.gif")){

                public int getVisibility() {
                    return Actions.this.ui.isCdlWorking() ? 2 : 1;
                }

                public int run(ActionMonitor monitor) {
                    FileDialog dialog = new FileDialog(Actions.this.ui.getShell(), 4096);
                    dialog.setFilterNames(new String[]{"CDL File"});
                    dialog.setFilterExtensions(new String[]{"*.cdl"});
                    String filename = dialog.open();
                    if (filename == null) {
                        return 2;
                    }
                    File file = new File(filename);
                    if (!file.exists() || !file.canRead()) {
                        return 3;
                    }
                    Actions.this.model.setCdlFile(file);
                    Actions.this.ui.log("CDL file '" + file.getPath() + "' loaded.\n");
                    return 1;
                }
            };
        }
        return this.openCdlFileAction;
    }

    public Action getOpenCdlFileAction(TextField field) {
        return new Action.Stub("\u2026"){

            public int getVisibility() {
                return Actions.this.ui.isCdlWorking() ? 2 : 1;
            }

            public int run(ActionMonitor monitor) {
                FileDialog dialog = new FileDialog(Actions.this.ui.getShell(), 4096);
                dialog.setFilterNames(new String[]{"CDL File"});
                dialog.setFilterExtensions(new String[]{"*.cdl"});
                String filename = dialog.open();
                if (filename == null) {
                    return 2;
                }
                File file = new File(filename);
                if (!file.exists() || !file.canRead()) {
                    return 3;
                }
                Actions.this.model.setCdlFile(file);
                Actions.this.ui.log("CDL file '" + file.getPath() + "' loaded.\n");
                return 1;
            }
        };
    }

    public Action getOpenProgramAction() {
        if (this.openProgramFileAction == null) {
            this.openProgramFileAction = new Action.Stub("Open Program File\u2026", this.getImage("eclipse/open_edit.gif")){

                public int run(ActionMonitor monitor) {
                    FileDialog dialog = new FileDialog(Actions.this.ui.getShell(), 4098);
                    dialog.setFilterNames(new String[]{"Fiacre Program"});
                    dialog.setFilterExtensions(new String[]{"*.fcr"});
                    dialog.open();
                    if (dialog.getFileNames().length == 0) {
                        return 2;
                    }
                    Actions.this.model.clearsProgramFileList();
                    for (String oneFilename : dialog.getFileNames()) {
                        File file = new File(dialog.getFilterPath(), oneFilename);
                        if (!file.exists() || !file.canRead()) {
                            Actions.this.ui.error("Can't read file '" + file.getPath() + "'.\n");
                            continue;
                        }
                        Actions.this.model.addProgramFile(file);
                        Actions.this.ui.log("Program file '" + file.getPath() + "' added.\n");
                    }
                    return 1;
                }
            };
        }
        return this.openProgramFileAction;
    }

    public Action getAddProgramAction(ListField<File> field) {
        return new Action.Stub("+"){

            public int run(ActionMonitor monitor) {
                FileDialog dialog = new FileDialog(Actions.this.ui.getShell(), 4098);
                dialog.setFilterNames(new String[]{"Fiacre Program"});
                dialog.setFilterExtensions(new String[]{"*.fcr"});
                dialog.open();
                if (dialog.getFileNames().length == 0) {
                    return 2;
                }
                for (String oneFilename : dialog.getFileNames()) {
                    File file = new File(dialog.getFilterPath(), oneFilename);
                    if (!file.exists() || !file.canRead()) {
                        Actions.this.ui.error("Can't read file '" + file.getPath() + "'.\n");
                        return 3;
                    }
                    Actions.this.model.addProgramFile(file);
                    Actions.this.ui.log("Program file '" + file.getPath() + "' added.\n");
                }
                return 1;
            }
        };
    }

    public Action getRemoveProgramAction(final ListField<File> field) {
        return new Action.Stub("-"){

            public int getVisibility() {
                return field.getSingleSelection() != null ? 1 : 2;
            }

            public int run(ActionMonitor monitor) {
                File file = (File)field.getSingleSelection();
                Actions.this.model.removeProgramFile(file);
                Actions.this.ui.log("Program file '" + file.getPath() + "' removed.\n");
                return 1;
            }
        };
    }

    public Action getUpProgramAction(final ListField<File> field) {
        return new Action.Stub("^"){

            public int getVisibility() {
                File file = (File)field.getSingleSelection();
                return Actions.this.model.canUpProgramFile(file) ? 1 : 2;
            }

            public int run(ActionMonitor monitor) {
                File file = (File)field.getSingleSelection();
                Actions.this.model.upProgramFile(file);
                return 1;
            }
        };
    }

    public Action getDownProgramAction(final ListField<File> field) {
        return new Action.Stub("v"){

            public int getVisibility() {
                File file = (File)field.getSingleSelection();
                return Actions.this.model.canDownProgramFile(file) ? 1 : 2;
            }

            public int run(ActionMonitor monitor) {
                File file = (File)field.getSingleSelection();
                Actions.this.model.downProgramFile(file);
                return 1;
            }
        };
    }

    public Action getOpenFormulaAction() {
        if (this.openFormulasAction == null) {
            this.openFormulasAction = new Action.Stub("Open Formulas\u2026", this.getImage("eclipse/open_edit.gif")){

                public int run(ActionMonitor monitor) {
                    FileDialog dialog = new FileDialog(Actions.this.ui.getShell(), 4096);
                    dialog.setFilterNames(new String[]{"Formula File"});
                    dialog.setFilterExtensions(new String[]{"*.ltl"});
                    String filename = dialog.open();
                    if (filename == null) {
                        return 2;
                    }
                    File file = new File(filename);
                    if (!file.exists() || !file.canRead()) {
                        return 3;
                    }
                    Actions.this.model.setFormulasFile(file);
                    Actions.this.ui.log("Formulas file '" + file.getPath() + "' loaded.\n");
                    return 1;
                }
            };
        }
        return this.openFormulasAction;
    }

    public Action getOpenFormulaAction(TextField field) {
        return new Action.Stub("\u2026"){

            public int run(ActionMonitor monitor) {
                FileDialog dialog = new FileDialog(Actions.this.ui.getShell(), 4096);
                dialog.setFilterNames(new String[]{"Formula File"});
                dialog.setFilterExtensions(new String[]{"*.ltl"});
                String filename = dialog.open();
                if (filename == null) {
                    return 2;
                }
                File file = new File(filename);
                if (!file.exists() || !file.canRead()) {
                    return 3;
                }
                Actions.this.model.setFormulasFile(file);
                Actions.this.ui.log("Formulas file '" + file.getPath() + "' loaded.\n");
                return 1;
            }
        };
    }

    public Action getSaveResultAction() {
        if (this.saveResultAction == null) {
            this.saveResultAction = new Action.Stub("Save result\u2026", this.getImage("eclipse/save_edit.gif")){

                public int getVisibility() {
                    return Actions.this.model.hasResults() ? 1 : 2;
                }

                public int run(ActionMonitor monitor) {
                    File parentFile = Actions.this.model.getCdlFile();
                    if (parentFile == null) {
                        parentFile = Actions.this.model.getExplorableProgramFile();
                    }
                    String prefix = parentFile.getName();
                    int dotIndex = prefix.lastIndexOf(46);
                    prefix = prefix.substring(0, dotIndex);
                    String suffix = "_results_" + new SimpleDateFormat("yyMMddHHmmss").format(new Date()) + ".txt";
                    File resultFile = new File(parentFile.getParentFile(), prefix + suffix);
                    FileDialog dialog = new FileDialog(Actions.this.ui.getShell(), 8192);
                    dialog.setFilterNames(new String[]{"Result file"});
                    dialog.setFilterExtensions(new String[]{"*.txt"});
                    dialog.setFileName(resultFile.getName());
                    dialog.setFilterPath(resultFile.getParent());
                    String filename = dialog.open();
                    if (filename == null) {
                        return 2;
                    }
                    File toWriteFile = new File(filename);
                    try {
                        MergerUtil.writeFile((File)toWriteFile, (String)Actions.this.model.getResultDescription(), (String)"UTF-8");
                    }
                    catch (Exception e) {
                        Actions.this.ui.error(DiagnosticUtil.createMessage((Throwable)e));
                        return 3;
                    }
                    return 1;
                }
            };
        }
        return this.saveResultAction;
    }

    public Action getExportAction() {
        if (this.exportAction == null) {
            this.exportAction = new Action.Container("Export", new Action[]{this.getExportScrambledProgramAction(), this.getExportLabelledProgramAction()});
        }
        return this.exportAction;
    }

    public Action getExportScrambledProgramAction() {
        if (this.exportScrambledProgramAction == null) {
            this.exportScrambledProgramAction = new Action.Stub("Scrambled Program"){

                public int getVisibility() {
                    return Actions.this.model.getProgramFileList().isEmpty() ? 2 : 1;
                }

                public int run(ActionMonitor monitor) {
                    try {
                        Actions.this.model.exportScrambledProgram();
                    }
                    catch (Exception e) {
                        Actions.this.ui.error(DiagnosticUtil.createMessage((Throwable)e));
                        return 3;
                    }
                    return 1;
                }
            };
        }
        return this.exportScrambledProgramAction;
    }

    public Action getExportLabelledProgramAction() {
        if (this.exportLabelledProgramAction == null) {
            this.exportLabelledProgramAction = new Action.Stub("Label Program"){

                public int getVisibility() {
                    return Actions.this.model.getProgramFileList().isEmpty() ? 2 : 1;
                }

                public int run(ActionMonitor monitor) {
                    try {
                        Actions.this.model.exportLabelledProgram();
                    }
                    catch (Exception e) {
                        Actions.this.ui.error(DiagnosticUtil.createMessage((Throwable)e));
                        return 3;
                    }
                    return 1;
                }
            };
        }
        return this.exportLabelledProgramAction;
    }

    public Action getClearCdlFileAction() {
        if (this.clearCdlAction == null) {
            this.clearCdlAction = new Action.Stub("Clear CDL File", this.getImage("eclipse/clear.gif")){

                public int getVisibility() {
                    return Actions.this.model.getCdlFile() != null ? 1 : 2;
                }

                public int run(ActionMonitor monitor) {
                    Actions.this.model.setCdlFile(null);
                    return 1;
                }
            };
        }
        return this.clearCdlAction;
    }

    public Action getClearProgramListAction() {
        if (this.clearProgramListAction == null) {
            this.clearProgramListAction = new Action.Stub("Clear Program List", this.getImage("eclipse/clear.gif")){

                public int getVisibility() {
                    return Actions.this.model.getProgramFileList().size() > 0 ? 1 : 2;
                }

                public int run(ActionMonitor monitor) {
                    Actions.this.model.clearsProgramFileList();
                    return 1;
                }
            };
        }
        return this.clearProgramListAction;
    }

    public Action getClearProgramListAction(ListField<File> field) {
        return new Action.Stub("Clear program", this.getImage("eclipse/clear.gif")){

            public int getVisibility() {
                return Actions.this.model.getProgramFileList().size() > 0 ? 1 : 2;
            }

            public int run(ActionMonitor monitor) {
                Actions.this.model.clearsProgramFileList();
                return 1;
            }
        };
    }

    public Action getClearFormulasAction() {
        if (this.clearFormulasAction == null) {
            this.clearFormulasAction = new Action.Stub("Clear Formulas File", this.getImage("eclipse/clear.gif")){

                public int getVisibility() {
                    return Actions.this.model.getFormulasFile() != null ? 1 : 2;
                }

                public int run(ActionMonitor monitor) {
                    Actions.this.model.setFormulasFile(null);
                    return 1;
                }
            };
        }
        return this.clearFormulasAction;
    }

    public Action getPreferencesAction() {
        if (this.preferencesAction == null) {
            this.preferencesAction = new Action.Stub("Preferences"){

                public int run(ActionMonitor monitor) {
                    OBPtConfigurationController configurationController = new OBPtConfigurationController(Actions.this.ui.getShell());
                    configurationController.setSubject(Actions.this.ui.getConfiguration());
                    FieldDialog dialog = new FieldDialog(Actions.this.ui.getShell(), "OBPt", "Tina Configuration", 6, (Controller)configurationController);
                    dialog.setButtonLabel(new String[]{"Ok"});
                    dialog.open();
                    return 1;
                }
            };
        }
        return this.preferencesAction;
    }

    public Action getQuitAction() {
        if (this.quitAction == null) {
            this.quitAction = new Action.Stub("Quit OBPt"){

                public int run(ActionMonitor monitor) {
                    Actions.this.ui.getShell().dispose();
                    return 1;
                }
            };
        }
        return this.quitAction;
    }

    public Action getProgramAction() {
        if (this.programAction == null) {
            this.programAction = new Action.Container("Program", new Action[]{this.getExploreProgramAction(), this.getVerifyAction(), this.getSeparatorAction(), this.getStopAction()});
        }
        return this.programAction;
    }

    public Action getExploreProgramAction() {
        if (this.exploreProgramAction == null) {
            this.exploreProgramAction = new Action.Stub("Explore"){

                public int getVisibility() {
                    return Actions.this.ui.canExplore() ? 1 : 2;
                }

                public int run(ActionMonitor monitor) {
                    Actions.this.ui.explore();
                    return 1;
                }
            };
        }
        return this.exploreProgramAction;
    }

    public Action getVerifyAction() {
        if (this.verifyAction == null) {
            this.verifyAction = new Action.Stub("Verify"){

                public int getVisibility() {
                    return Actions.this.ui.canVerify() ? 1 : 2;
                }

                public int run(ActionMonitor monitor) {
                    Actions.this.ui.verify();
                    return 1;
                }
            };
        }
        return this.verifyAction;
    }

    public Action getStopAction() {
        if (this.stopAction == null) {
            this.stopAction = new Action.Stub("Stop"){

                public int getVisibility() {
                    return Actions.this.ui.isWorking() ? 1 : 2;
                }

                public int run(ActionMonitor monitor) {
                    Actions.this.ui.stopCurrentAction();
                    return 1;
                }
            };
        }
        return this.stopAction;
    }

    public Action getViewAction() {
        if (this.viewAction == null) {
            this.viewAction = new Action.Container("View", new Action[]{this.getShowProgramSourceAction(), this.getUseDescriptionCommentAction(), this.getSeparatorAction(), this.getShowExplorationResultAction(), this.getShowExplorationGraphAction(), this.getSeparatorAction(), this.getClearConsoleAction()});
        }
        return this.viewAction;
    }

    public Action getShowProgramSourceAction() {
        if (this.showProgramSourceAction == null) {
            this.showProgramSourceAction = new Action.Stub("Show Program Source", 282){

                public boolean getState() {
                    return Actions.this.ui.isShowPogramSource();
                }

                public int run(ActionMonitor monitor) {
                    Actions.this.ui.showProgramSource(!Actions.this.ui.isShowPogramSource());
                    return 1;
                }
            };
        }
        return this.showProgramSourceAction;
    }

    public Action getUseDescriptionCommentAction() {
        if (this.useDescriptionCommentAction == null) {
            this.useDescriptionCommentAction = new Action.Stub("Use description comments in graphs", 282){

                public boolean getState() {
                    return Actions.this.ui.isUseDescription();
                }

                public int run(ActionMonitor monitor) {
                    Actions.this.ui.setUseDescription(!Actions.this.ui.isUseDescription());
                    return 1;
                }
            };
        }
        return this.useDescriptionCommentAction;
    }

    public Action getShowExplorationGraphAction() {
        if (this.showExplorationGraphAction == null) {
            this.showExplorationGraphAction = new Action.Stub("Show Exploration Graph"){

                public int getVisibility() {
                    return Actions.this.ui.canShowExploration() ? 1 : 2;
                }

                public int run(ActionMonitor monitor) {
                    Actions.this.ui.showExplorationGraph();
                    return 1;
                }
            };
        }
        return this.showExplorationGraphAction;
    }

    public Action getShowExplorationResultAction() {
        if (this.showExplorationResultAction == null) {
            this.showExplorationResultAction = new Action.Stub("Show Exploration Result"){

                public int getVisibility() {
                    return Actions.this.ui.canShowExploration() ? 1 : 2;
                }

                public int run(ActionMonitor monitor) {
                    Actions.this.ui.showExplorationResult();
                    return 1;
                }
            };
        }
        return this.showExplorationResultAction;
    }

    public Action getClearConsoleAction() {
        if (this.clearConsoleAction == null) {
            this.clearConsoleAction = new Action.Stub("Clear console", 10){

                public int run(ActionMonitor monitor) {
                    Actions.this.ui.clearConsole();
                    return 1;
                }
            };
        }
        return this.clearConsoleAction;
    }

    public Image getImage(String filename) {
        return this.ui.getResources().getImage(filename);
    }
}

