/*
 * Decompiled with CFR 0.152.
 */
package obp.interpreter.runtime;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import obp.explorer.runtime.Component;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.Program;
import obp.explorer.runtime.ReferencedArgument;
import obp.explorer.runtime.SymbolsTable;
import obp.explorer.runtime.core.Channel;
import obp.explorer.runtime.obs.AtomicAction;
import obp.interpreter.IBehavior;
import obp.interpreter.IProgram;
import obp.interpreter.ITransition;
import obp.interpreter.runtime.BehaviorImpl;
import obp.interpreter.runtime.ChannelImpl;
import obp.interpreter.runtime.EventImpl;
import obp.interpreter.runtime.EventsLib;
import obp.interpreter.runtime.InterpreterContext;
import obp.interpreter.runtime.InterpreterLib;
import obp.interpreter.runtime.RootComponentImpl;
import obp.interpreter.runtime.RootConfigurationImpl;
import obp.interpreter.runtime.TransitionImpl;
import obp.lua.LuaUtil;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaClosure;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaValue;

public class ProgramImpl
implements Program,
InterpreterContext {
    private final Globals lua;
    private final IProgram program;
    private final Map<String, String> metaInformations = new HashMap<String, String>();
    private SymbolsTable symbols;
    private String[] eventNames;
    private LuaValue eventsLibrary;
    private Channel[] channels;
    protected ReferencedArgument<EventImpl[]> eventStorage;
    protected short currentBehavior;
    protected List<AtomicAction> currentActions;
    protected Configuration currentConfiguration;

    public ProgramImpl(Globals lua, IProgram program) {
        this.lua = lua;
        this.program = program;
        this.metaInformations.put("Mode", "Interpreted");
    }

    @Override
    public Map<String, String> getMetaInformations() {
        return this.metaInformations;
    }

    @Override
    public int getIoQueueSize(String name) {
        return Integer.MAX_VALUE;
    }

    @Override
    public Component getRoot(SymbolsTable symbols) throws Exception {
        this.symbols = symbols;
        this.initializeLibs();
        this.initializeEvents();
        this.initializeChannels();
        RootComponentImpl root = this.initializeRoot();
        this.initializeInformals();
        this.initializeUserInit();
        return root;
    }

    private void initializeUserInit() throws IOException {
        String init = this.program.getInit();
        if (init != null) {
            LuaFunction value = LuaUtil.parseString(init, this.lua);
            value.call();
        }
    }

    private void initializeLibs() {
        this.lua.load((LuaValue)new InterpreterLib(this));
        this.eventsLibrary = this.lua.load((LuaValue)new EventsLib(this));
    }

    private void initializeEvents() {
        List<String> eventSet = this.program.getEventList();
        this.eventNames = new String[eventSet.size()];
        for (String event : eventSet) {
            short id = this.symbols.newEventId(event);
            this.eventNames[id] = event;
            this.lua.set(event, (int)id);
        }
    }

    private void initializeChannels() {
        ArrayList<String> channelSet = new ArrayList<String>();
        HashMap<String, Integer> channelUseCount = new HashMap<String, Integer>();
        for (IBehavior iBehavior : this.program.getBehaviorList()) {
            for (String channel : iBehavior.getTriggerList()) {
                int count;
                if (channelUseCount.containsKey(channel)) {
                    count = 1 + (Integer)channelUseCount.get(channel);
                } else {
                    count = 1;
                    channelSet.add(channel);
                }
                channelUseCount.put(channel, count);
            }
        }
        for (Map.Entry entry : channelUseCount.entrySet()) {
            if ((Integer)entry.getValue() != 1) continue;
            System.err.println("[Warning] Channel '" + (String)entry.getKey() + "' is used only by one behavior.");
        }
        this.channels = new Channel[channelSet.size()];
        for (String string : channelSet) {
            Integer count = (Integer)channelUseCount.get(string);
            ChannelImpl instance = new ChannelImpl(string, this.symbols, count);
            short id = instance.id;
            this.channels[id] = instance;
            this.lua.set(string, (int)id);
        }
    }

    private void initializeInformals() {
        for (String informal : this.program.getInformalList()) {
            this.symbols.newInformalId(informal);
        }
    }

    private RootComponentImpl initializeRoot() throws IOException {
        RootComponentImpl rootComponent = new RootComponentImpl(this, this.program);
        if (rootComponent.getRootBehavior() != null) {
            this.eventStorage = new ReferencedArgument<EventImpl[]>(rootComponent.getRootBehavior().id){

                @Override
                public Class<EventImpl[]> getArgumentType() {
                    return EventImpl[].class;
                }

                @Override
                public EventImpl[] get(Configuration configuration) {
                    RootConfigurationImpl rootConfigurationImpl = (RootConfigurationImpl)configuration.behaviorConfigurations[this.ownerId];
                    return rootConfigurationImpl.events;
                }

                @Override
                public void set(Configuration configuration, EventImpl[] value) {
                    RootConfigurationImpl rootConfigurationImpl = (RootConfigurationImpl)configuration.behaviorConfigurations[this.ownerId];
                    rootConfigurationImpl.events = value;
                }
            };
        }
        return rootComponent;
    }

    @Override
    public Globals getLua() {
        return this.lua;
    }

    @Override
    public IProgram getProgram() {
        return this.program;
    }

    @Override
    public SymbolsTable getSymbols() {
        return this.symbols;
    }

    @Override
    public List<String> getEvents() {
        return this.program.getEventList();
    }

    @Override
    public Channel[] getChannels() {
        return this.channels;
    }

    @Override
    public boolean doesLuaConstantUseEvents(LuaValue name) {
        LuaValue value = this.lua.get(name);
        if (value == this.eventsLibrary) {
            return true;
        }
        if (value.isclosure()) {
            LuaClosure closure = (LuaClosure)value;
            for (LuaValue call : closure.p.k) {
                if (!this.doesLuaConstantUseEvents(call)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public BehaviorImpl createBehavior(IBehavior behavior) throws IOException {
        return new BehaviorImpl(this, behavior);
    }

    @Override
    public TransitionImpl createTransition(IBehavior behavior, short behaviorId, ITransition transition) throws IOException {
        return new TransitionImpl(this, behavior, behaviorId, transition);
    }

    @Override
    public void exploring(short behavior, List<AtomicAction> actions2, Configuration configuration) {
        this.currentBehavior = behavior;
        this.currentActions = actions2;
        this.currentConfiguration = configuration;
    }

    @Override
    public short addInformal(String informal) {
        if (!this.program.getInformalList().contains(informal)) {
            this.program.addInformal(informal);
            return this.symbols.newInformalId(informal);
        }
        return this.symbols.getInformalId(informal);
    }

    @Override
    public void unloadExternalLibrary() {
    }
}

