/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.transfo;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import obp.fiacre.model.Array;
import obp.fiacre.model.BoolLiteral;
import obp.fiacre.model.BoolType;
import obp.fiacre.model.Constr;
import obp.fiacre.model.ConstrExp;
import obp.fiacre.model.Exp;
import obp.fiacre.model.Field;
import obp.fiacre.model.InlineArray;
import obp.fiacre.model.InlineRecord;
import obp.fiacre.model.IntType;
import obp.fiacre.model.Interval;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.NatLiteral;
import obp.fiacre.model.NatType;
import obp.fiacre.model.Queue;
import obp.fiacre.model.Record;
import obp.fiacre.model.Type;
import obp.fiacre.model.TypeId;
import obp.fiacre.model.Union;
import obp.fiacre.model.ValuedField;
import obp.fiacre.util.TypeUtil;

public final class TypeEnumerator
extends ModelVisitor.Stub {
    public static final int MAX_ENUM = 100000;
    public static final BigInteger NUM_INTEGER = BigInteger.ZERO.setBit(33);
    public static final BigInteger NUM_NATURAL = BigInteger.ZERO.setBit(32);
    private final Stack<List<Exp>> expListStack = new Stack();

    public static BigInteger countExp(Type type) {
        if (type instanceof IntType) {
            return NUM_INTEGER;
        }
        if (type instanceof NatType) {
            return NUM_NATURAL;
        }
        if (type instanceof BoolType) {
            return BigInteger.ONE.add(BigInteger.ONE);
        }
        if (type instanceof TypeId) {
            return TypeEnumerator.countExp(((TypeId)type).getDecl().getIs());
        }
        if (type instanceof Array) {
            int size = TypeUtil.computeArraySizeExpression(((Array)type).getSize());
            Type subType = ((Array)type).getType();
            return TypeEnumerator.countExp(subType).pow(size);
        }
        if (type instanceof Interval) {
            int max = TypeUtil.computeArraySizeExpression(((Interval)type).getMaxi());
            int min = TypeUtil.computeArraySizeExpression(((Interval)type).getMini());
            int size = max - min + 1;
            return BigInteger.valueOf(size);
        }
        if (type instanceof Queue) {
            Type subType = ((Queue)type).getType();
            BigInteger subCount = TypeEnumerator.countExp(subType);
            int size = TypeUtil.computeArraySizeExpression(((Queue)type).getSize());
            BigInteger result = BigInteger.ZERO;
            for (int i = 0; i < size; ++i) {
                if (i == 0) {
                    result = result.add(BigInteger.ONE);
                    continue;
                }
                BigInteger current = subCount.pow(i);
                result = result.add(current);
            }
            return result;
        }
        if (type instanceof Record) {
            List<Field> fields = ((Record)type).getFieldList();
            BigInteger result = BigInteger.ONE;
            for (Field field : fields) {
                Type subType = field.getType();
                BigInteger subCount = TypeEnumerator.countExp(subType);
                result = result.multiply(subCount);
            }
            return result;
        }
        if (type instanceof Union) {
            List<Constr> constrs = ((Union)type).getConstrList();
            BigInteger result = BigInteger.ZERO;
            for (Constr constr : constrs) {
                Type subType = constr.getType();
                BigInteger subCount = subType == null ? BigInteger.ONE : TypeEnumerator.countExp(subType);
                result = result.add(subCount);
            }
            return result;
        }
        throw new IllegalArgumentException("Type " + type.getClass().getSimpleName() + " is unknwown.");
    }

    public static List<Exp> enumerateExps(Type type) {
        if (TypeEnumerator.countExp(type).compareTo(BigInteger.valueOf(100000L)) > 0) {
            throw new IllegalArgumentException("Type " + type.getClass().getSimpleName() + " has too many matching expressions to be generated.");
        }
        TypeEnumerator enumerator = new TypeEnumerator();
        type.accept(enumerator);
        return enumerator.getResult();
    }

    private List<Exp> getResult() {
        return this.expListStack.pop();
    }

    private InlineArray copyExp(InlineArray arrayExp) {
        InlineArray result = new InlineArray();
        int size = arrayExp.getElemCount();
        for (int i = 0; i < size; ++i) {
            Exp elem = arrayExp.getElem(i);
            result.addElem(elem);
        }
        return result;
    }

    private InlineRecord copyExp(InlineRecord recordExp) {
        InlineRecord result = new InlineRecord();
        int size = recordExp.getValueCount();
        for (int i = 0; i < size; ++i) {
            ValuedField field = recordExp.getValue(i);
            result.addValue(field);
        }
        return result;
    }

    @Override
    public void visitArray(Array toVisit) {
        toVisit.getType().accept(this);
        List<Exp> subTypeExpList = this.expListStack.pop();
        ArrayList<InlineArray> arrayExpList = new ArrayList<InlineArray>();
        arrayExpList.add(new InlineArray());
        int size = TypeUtil.computeArraySizeExpression(toVisit.getSize());
        for (int i = 0; i < size; ++i) {
            ArrayList<InlineArray> oldArrayExpList = arrayExpList;
            arrayExpList = new ArrayList();
            for (Exp exp : oldArrayExpList) {
                for (Exp subTypeExp : subTypeExpList) {
                    InlineArray arrayExp = this.copyExp((InlineArray)exp);
                    arrayExp.addElem(subTypeExp);
                    arrayExpList.add(arrayExp);
                }
            }
        }
        this.expListStack.push(arrayExpList);
    }

    @Override
    public void visitBoolType(BoolType toVisit) {
        ArrayList<BoolLiteral> expList = new ArrayList<BoolLiteral>();
        BoolLiteral expTrue = new BoolLiteral();
        expTrue.setValue(true);
        BoolLiteral expFalse = new BoolLiteral();
        expFalse.setValue(false);
        expList.add(expTrue);
        expList.add(expFalse);
        this.expListStack.push(expList);
    }

    @Override
    public void visitIntType(IntType toVisit) {
        throw new IllegalArgumentException("Integer type can't be enumerated.");
    }

    @Override
    public void visitNatType(NatType toVisit) {
        throw new IllegalArgumentException("Natural type can't be enumerated.");
    }

    @Override
    public void visitInterval(Interval toVisit) {
        int max = TypeUtil.computeArraySizeExpression(toVisit.getMaxi());
        int min = TypeUtil.computeArraySizeExpression(toVisit.getMini());
        ArrayList<NatLiteral> expList = new ArrayList<NatLiteral>();
        for (int i = min; i <= max; ++i) {
            NatLiteral currentExp = new NatLiteral();
            currentExp.setValue(i);
            expList.add(currentExp);
        }
        this.expListStack.push(expList);
    }

    @Override
    public void visitQueue(Queue toVisit) {
        throw new IllegalArgumentException("Queue type can't be enumerated.");
    }

    private List<ValuedField> getValuedFieldList(Field field) {
        String name = field.getName();
        field.getType().accept(this);
        List<Exp> valueExpList = this.expListStack.pop();
        ArrayList<ValuedField> valuedFieldList = new ArrayList<ValuedField>();
        for (Exp valueExp : valueExpList) {
            ValuedField valuedField = new ValuedField();
            valuedField.setField(name);
            valuedField.setValue(valueExp);
            valuedFieldList.add(valuedField);
        }
        return valuedFieldList;
    }

    @Override
    public void visitRecord(Record toVisit) {
        ArrayList<InlineRecord> expList = new ArrayList<InlineRecord>();
        expList.add(new InlineRecord());
        List<Field> fields = toVisit.getFieldList();
        for (Field field : fields) {
            List<ValuedField> valuedFieldList = this.getValuedFieldList(field);
            ArrayList<InlineRecord> oldExpList = expList;
            expList = new ArrayList();
            for (Exp exp : oldExpList) {
                for (ValuedField valuedField : valuedFieldList) {
                    InlineRecord recordExp = this.copyExp((InlineRecord)exp);
                    recordExp.addValue(valuedField);
                    expList.add(recordExp);
                }
            }
        }
        this.expListStack.push(expList);
    }

    @Override
    public void visitTypeId(TypeId toVisit) {
        toVisit.getDecl().getIs().accept(this);
    }

    @Override
    public void visitUnion(Union toVisit) {
        ArrayList<ConstrExp> expList = new ArrayList<ConstrExp>();
        for (int i = 0; i < toVisit.getConstrCount(); ++i) {
            String name = toVisit.getConstr(i).getName();
            if (toVisit.getConstr(i).getType() == null) {
                ConstrExp constrExp = new ConstrExp();
                constrExp.setName(name);
                expList.add(constrExp);
                continue;
            }
            toVisit.getConstr(i).getType().accept(this);
            List<Exp> valueExpList = this.expListStack.pop();
            for (Exp valueExp : valueExpList) {
                ConstrExp constrExp = new ConstrExp();
                constrExp.setName(name);
                constrExp.setArg(valueExp);
                expList.add(constrExp);
            }
        }
        this.expListStack.push(expList);
    }
}

