/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.matcher;

import java.util.Arrays;
import obp.explorer.runtime.ExplorationContext;
import obp.explorer.runtime.matcher.Matcher;
import obp.explorer.runtime.obs.SynchronousCommunicationAction;

public class SynchronousEventMatcher
extends Matcher {
    private final short channelId;
    private final short sourceId;
    private final short targetId;
    private final Matcher[] messageMatchers;

    public SynchronousEventMatcher(ExplorationContext context, short channelId, short sourceId, short targetId, Matcher[] messageMatchers) {
        super(context);
        this.channelId = channelId;
        this.sourceId = sourceId;
        this.targetId = targetId;
        this.messageMatchers = messageMatchers;
    }

    @Override
    public boolean match(Object argument) {
        if (argument.getClass() == SynchronousCommunicationAction.class) {
            SynchronousCommunicationAction action = (SynchronousCommunicationAction)argument;
            if (this.channelId != action.channelId) {
                return false;
            }
            if (this.sourceId >= 0 && this.sourceId != action.sourceId) {
                return false;
            }
            if (this.targetId >= 0 && this.targetId != action.targetId) {
                return false;
            }
            if (this.messageMatchers != null) {
                for (int i = 0; i < this.messageMatchers.length; ++i) {
                    if (this.messageMatchers[i].match(action.values[i])) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append("sync from ");
        if (this.sourceId >= 0) {
            text.append(this.sourceId);
        } else {
            text.append("any");
        }
        text.append(" to ");
        if (this.targetId >= 0) {
            text.append(this.targetId);
        } else {
            text.append("any");
        }
        text.append(" of channel ");
        text.append(this.channelId);
        text.append(" with ");
        text.append(Arrays.toString(this.messageMatchers));
        return text.toString();
    }
}

