/*
 * Decompiled with CFR 0.152.
 */
package spinja.search;

import java.util.Arrays;
import spinja.search.SearchableStack;

public class Queue {
    private final State nextDepth;
    private volatile State head;
    private volatile State tail;
    private volatile int filled;
    private int depth;

    public Queue() {
        this.tail = this.head = (this.nextDepth = new State(null, null, -1));
        this.filled = 0;
        this.depth = 0;
    }

    public synchronized boolean add(State state) {
        this.tail.next = state;
        this.tail = state;
        ++this.filled;
        return true;
    }

    public synchronized State peek() {
        return this.head;
    }

    public synchronized State remove() {
        if (this.head == null) {
            return null;
        }
        if (this.head == this.nextDepth) {
            this.head = this.head.next;
            this.add(this.nextDepth);
            ++this.depth;
        }
        State state = this.head;
        this.head = this.head.next;
        --this.filled;
        state.next = null;
        return state;
    }

    public int size() {
        return this.filled;
    }

    public void clear() {
    }

    public class State
    implements SearchableStack {
        public final State previous;
        private State next;
        public final byte[] state;
        public final int transId;

        public State(State state, byte[] byArray, int n) {
            this.previous = state;
            this.state = byArray;
            this.transId = n;
        }

        @Override
        public boolean containsState(byte[] byArray, int n) {
            State state = this;
            while (state != null) {
                if (Arrays.equals(state.state, byArray)) {
                    return true;
                }
                state = state.previous;
            }
            return false;
        }
    }
}

