/*
 * Decompiled with CFR 0.152.
 */
package spinja.promela.compiler.expression;

import java.util.HashSet;
import java.util.Set;
import spinja.promela.compiler.expression.Expression;
import spinja.promela.compiler.parser.MyParseException;
import spinja.promela.compiler.parser.ParseException;
import spinja.promela.compiler.parser.Token;
import spinja.promela.compiler.variable.VariableAccess;
import spinja.promela.compiler.variable.VariableType;

public class CompareExpression
extends Expression {
    private static final long serialVersionUID = -7625932622450298223L;
    private final Expression ex1;
    private final Expression ex2;

    public CompareExpression(Token token, Expression expression, Expression expression2) {
        super(token);
        this.ex1 = expression;
        this.ex2 = expression2;
    }

    @Override
    public String getBoolExpression() throws ParseException {
        return "(" + this.ex1.getIntExpression() + " " + this.getToken().image + " " + this.ex2.getIntExpression() + ")";
    }

    @Override
    public int getConstantValue() throws ParseException {
        switch (this.getToken().kind) {
            case 75: {
                return this.ex1.getConstantValue() < this.ex2.getConstantValue() ? 1 : 0;
            }
            case 77: {
                return this.ex1.getConstantValue() > this.ex2.getConstantValue() ? 1 : 0;
            }
            case 76: {
                return this.ex1.getConstantValue() <= this.ex2.getConstantValue() ? 1 : 0;
            }
            case 78: {
                return this.ex1.getConstantValue() >= this.ex2.getConstantValue() ? 1 : 0;
            }
            case 79: {
                return this.ex1.getConstantValue() == this.ex2.getConstantValue() ? 1 : 0;
            }
            case 80: {
                return this.ex1.getConstantValue() != this.ex2.getConstantValue() ? 1 : 0;
            }
        }
        throw new MyParseException("Unimplemented compare type: " + this.getToken().image, this.getToken());
    }

    @Override
    public String getIntExpression() throws ParseException {
        return "(" + this.ex1.getIntExpression() + " " + this.getToken().image + " " + this.ex2.getIntExpression() + " ? 1 : 0)";
    }

    @Override
    public VariableType getResultType() {
        return VariableType.BOOL;
    }

    @Override
    public String getSideEffect() throws ParseException {
        if (this.ex1.getSideEffect() != null || this.ex2.getSideEffect() != null) {
            throw new MyParseException("No sideeffect allowed in a comparison!", this.getToken());
        }
        return null;
    }

    @Override
    public Set<VariableAccess> readVariables() {
        HashSet<VariableAccess> hashSet = new HashSet<VariableAccess>();
        hashSet.addAll(this.ex1.readVariables());
        hashSet.addAll(this.ex2.readVariables());
        return hashSet;
    }

    @Override
    public String toString() {
        try {
            return this.getBoolExpression();
        }
        catch (ParseException parseException) {
            return "";
        }
    }
}

