/*
 * Decompiled with CFR 0.152.
 */
package plug.modules.synchronization.runtime;

import java.util.Arrays;
import plug.core.IConfiguration;
import plug.core.defaults.DefaultConfiguration;

public class SynchronizationConfiguration<C extends IConfiguration>
extends DefaultConfiguration<SynchronizationConfiguration<C>> {
    public C conf;
    public short phase;
    public boolean[] firedTransitions;

    public SynchronizationConfiguration<C> createCopy() {
        SynchronizationConfiguration<C> copy = new SynchronizationConfiguration<C>();
        copy.conf = this.conf.createCopy();
        copy.phase = this.phase;
        copy.firedTransitions = Arrays.copyOf(this.firedTransitions, this.firedTransitions.length);
        return copy;
    }

    public int hashCode() {
        return this.conf.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SynchronizationConfiguration)) {
            return false;
        }
        SynchronizationConfiguration other = (SynchronizationConfiguration)((Object)obj);
        if (this.phase != other.phase) {
            return false;
        }
        if (!this.conf.equals(other.conf)) {
            return false;
        }
        return Arrays.equals(this.firedTransitions, other.firedTransitions);
    }

    public boolean hasNextForPhase() {
        for (int i = 0; i < this.firedTransitions.length; ++i) {
            if (this.firedTransitions[i]) continue;
            return true;
        }
        return false;
    }

    public void canonize(int nextPhaseSize) {
        if (!this.hasNextForPhase()) {
            this.phase = (short)(this.phase + 1);
            this.firedTransitions = new boolean[nextPhaseSize];
        }
    }

    public static int clusterIndexGetter(SynchronizationConfiguration configuration) {
        return configuration.phase;
    }
}

