/*
 * Decompiled with CFR 0.152.
 */
package org.petitparser.context;

import org.petitparser.context.Failure;
import org.petitparser.context.Success;
import org.petitparser.context.Token;

public class Context {
    protected final String buffer;
    protected final int position;

    public Context(String buffer, int position) {
        this.buffer = buffer;
        this.position = position;
    }

    public String getBuffer() {
        return this.buffer;
    }

    public int getPosition() {
        return this.position;
    }

    public Success success(Object value) {
        return this.success(value, this.position);
    }

    public Success success(Object value, int position) {
        return new Success(this.buffer, position, value);
    }

    public Failure failure(String message) {
        return this.failure(message, this.position);
    }

    public Failure failure(String message, int position) {
        return new Failure(this.buffer, position, message);
    }

    public String toString() {
        int[] tuple = Token.lineAndColumnOf(this.buffer, this.position);
        return this.getClass().getSimpleName() + "[" + tuple[0] + ":" + tuple[1] + "]";
    }
}

