/*
 * Decompiled with CFR 0.152.
 */
package plug.language.tuml.simulation.ui;

import java.awt.Component;
import java.util.Map;
import java.util.Queue;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.State;
import tuml.interpreter.ActiveObject;
import tuml.interpreter.Composite;

public class TUMLTreeRenderer
extends DefaultTreeCellRenderer {
    public Map<String, ImageIcon> icons;

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
        if (userObject instanceof Composite) {
            this.setText(((Composite)userObject).getC().getName());
        } else if (userObject instanceof ActiveObject) {
            this.setText(((ActiveObject)userObject).toShortString().toString());
            this.setIcon(this.icons.get("processIcon"));
        } else if (userObject instanceof State) {
            this.setText(((State)userObject).getName());
            this.setIcon(this.icons.get("stateIcon"));
        } else if (userObject instanceof String && !"locals".equals((String)userObject)) {
            this.setIcon(this.icons.get("peersIcon"));
        } else if (userObject instanceof Queue) {
            Queue q = (Queue)userObject;
            String s = "[";
            boolean first = true;
            for (Signal sig : q) {
                if (!first) {
                    s = s + ", ";
                } else {
                    first = false;
                }
                s = s + sig.getName();
            }
            s = s + "]";
            this.setText(s);
            this.setIcon(this.icons.get("eventpoolIcon"));
        } else if (userObject instanceof String && "locals".equals((String)userObject)) {
            this.setIcon(this.icons.get("variablesIcon"));
        } else if (userObject instanceof Map.Entry) {
            this.setIcon(this.icons.get("localVarIcon"));
        }
        return this;
    }
}

