/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.util;

import obp.fiacre.model.IfStmt;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.ModelWalker;
import obp.fiacre.model.NullStmt;
import obp.fiacre.model.Program;
import obp.fiacre.model.Seq;
import obp.fiacre.model.Statement;
import obp.fiacre.model.To;

public class IfElseTransformer
extends ModelVisitor.Stub {
    private boolean somethingChanged = true;

    public static void transform(Program program) {
        IfElseTransformer transformer = new IfElseTransformer();
        while (transformer.somethingChanged) {
            transformer.somethingChanged = false;
            program.accept(new ModelWalker(transformer));
        }
    }

    @Override
    public void visitSeq(Seq toVisit) {
        for (int i = 0; i < toVisit.getStatementCount(); ++i) {
            Statement statement = toVisit.getStatement(i);
            if (!(statement instanceof IfStmt)) continue;
            IfStmt ifStmt = (IfStmt)statement;
            boolean breaking = ifStmt.getElse() == null || ifStmt.getElse() instanceof NullStmt;
            Statement then = ifStmt.getThen();
            if (then instanceof To) {
                breaking &= true;
            } else if (then instanceof Seq) {
                Seq seq = (Seq)then;
                breaking &= seq.getStatement(seq.getStatementCount() - 1) instanceof To;
            } else {
                breaking = false;
            }
            if (!breaking) continue;
            this.somethingChanged = true;
            Seq elseStmt = new Seq();
            ifStmt.setElse(elseStmt);
            while (toVisit.getStatementCount() > i + 1) {
                elseStmt.addStatement(toVisit.getStatement(i + 1));
                toVisit.removeStatement(i + 1);
            }
            break;
        }
    }
}

