/*
 * Decompiled with CFR 0.152.
 */
package org.petitparser.parser.primitive;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.petitparser.parser.Parser;
import org.petitparser.parser.primitive.CharacterParser;
import org.petitparser.parser.primitive.CharacterRange;

@FunctionalInterface
public interface CharacterPredicate {
    public static CharacterPredicate any() {
        return value -> true;
    }

    public static CharacterPredicate anyOf(String string) {
        List<CharacterRange> ranges = string.chars().mapToObj(value -> new CharacterRange((char)value, (char)value)).collect(Collectors.toList());
        return CharacterRange.toCharacterPredicate(ranges);
    }

    public static CharacterPredicate none() {
        return value -> false;
    }

    public static CharacterPredicate noneOf(String string) {
        List<CharacterRange> ranges = string.chars().mapToObj(value -> new CharacterRange((char)value, (char)value)).collect(Collectors.toList());
        return CharacterRange.toCharacterPredicate(ranges).not();
    }

    public static CharacterPredicate of(char character) {
        return value -> value == character;
    }

    public static CharacterPredicate range(char start, char stop) {
        return value -> start <= value && value <= stop;
    }

    public static CharacterPredicate ranges(char[] starts, char[] stops) {
        if (starts.length != stops.length) {
            throw new IllegalArgumentException("Invalid range sizes.");
        }
        for (int i = 0; i < starts.length; ++i) {
            if (starts[i] > stops[i]) {
                throw new IllegalArgumentException("Invalid range: " + starts[i] + "-" + stops[i]);
            }
            if (i + 1 >= starts.length || starts[i + 1] > stops[i]) continue;
            throw new IllegalArgumentException("Invalid sequence.");
        }
        return value -> {
            int index = Arrays.binarySearch(starts, value);
            return index >= 0 || index < -1 && value <= stops[-index - 2];
        };
    }

    public static CharacterPredicate pattern(String pattern) {
        return (CharacterPredicate)PatternParser.PATTERN.parse(pattern).get();
    }

    public boolean test(char var1);

    default public CharacterPredicate not() {
        return new NotCharacterPredicate(this);
    }

    public static class NotCharacterPredicate
    implements CharacterPredicate {
        private final CharacterPredicate predicate;

        public NotCharacterPredicate(CharacterPredicate predicate) {
            this.predicate = predicate;
        }

        @Override
        public boolean test(char value) {
            return !this.predicate.test(value);
        }

        @Override
        public CharacterPredicate not() {
            return this.predicate;
        }
    }

    public static class PatternParser {
        static final Parser PATTERN_SIMPLE = CharacterParser.any().map(value -> new CharacterRange(value.charValue(), value.charValue()));
        static final Parser PATTERN_RANGE = CharacterParser.any().seq(CharacterParser.of('-')).seq(CharacterParser.any()).map(values -> new CharacterRange(((Character)values.get(0)).charValue(), ((Character)values.get(2)).charValue()));
        static final Parser PATTERN_POSITIVE = PATTERN_RANGE.or(PATTERN_SIMPLE).star().map(CharacterRange::toCharacterPredicate);
        static final Parser PATTERN = CharacterParser.of('^').optional().seq(PATTERN_POSITIVE).map(predicate -> predicate.get(0) == null ? (CharacterPredicate)predicate.get(1) : ((CharacterPredicate)predicate.get(1)).not()).end();
    }
}

