/*
 * Decompiled with CFR 0.152.
 */
package spinja.promela.compiler.variable;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import spinja.promela.compiler.parser.ParseException;
import spinja.promela.compiler.variable.ChannelType;
import spinja.promela.compiler.variable.CustomVariableType;
import spinja.promela.compiler.variable.Variable;
import spinja.promela.compiler.variable.VariableContainer;
import spinja.util.StringWriter;

public class VariableStore
implements VariableContainer {
    private final List<Variable> vars = new LinkedList<Variable>();

    public static boolean canSkipVar(Variable variable) {
        return !variable.isWritten() && !(variable.getType() instanceof ChannelType);
    }

    @Override
    public void addVariable(Variable variable) {
        if (variable == null) {
            throw new IllegalArgumentException();
        }
        this.vars.add(variable);
    }

    public int getBufferSize() {
        int n = 0;
        for (Variable variable : this.vars) {
            if (VariableStore.canSkipVar(variable)) continue;
            for (int i = 0; i < variable.getArraySize(); ++i) {
                n += (variable.getType().getBits() - 1) / 8 + 1;
            }
        }
        return n;
    }

    @Override
    public Variable getVariable(String string) {
        for (Variable variable : this.vars) {
            if (!variable.getName().equals(string)) continue;
            return variable;
        }
        return null;
    }

    @Override
    public List<Variable> getVariables() {
        return new ArrayList<Variable>(this.vars);
    }

    @Override
    public boolean hasVariable(String string) {
        for (Variable variable : this.vars) {
            if (!variable.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public void printDefinitions(StringWriter stringWriter) throws ParseException {
        for (Variable variable : this.vars) {
            int n = variable.getInitExpr().getConstantValue();
            if (variable.getArraySize() == 1) {
                stringWriter.appendLine("private ", variable.getType().getJavaName(), " ", variable.getName(), " = ", n, ";");
                continue;
            }
            if (n != 0) {
                throw new ParseException("A initializing expression is not possible for an array declaration.");
            }
            stringWriter.appendLine("private ", variable.getType().getJavaName(), " ", variable.getName(), "[] = new ", variable.getType().getJavaName(), "[", variable.getArraySize(), "];");
        }
    }

    public void printEncode(StringWriter stringWriter) {
        for (Variable variable : this.vars) {
            if (VariableStore.canSkipVar(variable)) continue;
            if (variable.getType() instanceof CustomVariableType) {
                stringWriter.appendLine(variable.getName(), ".encode(_writer);");
                continue;
            }
            if (variable.getArraySize() > 1) {
                stringWriter.appendLine("for(int _i = 0; _i < ", variable.getArraySize(), "; _i++) {").indent();
            }
            stringWriter.appendPrefix().append("_writer.write");
            switch (variable.getType().getBits()) {
                case 1: {
                    stringWriter.append("Boolean");
                    break;
                }
                case 8: {
                    stringWriter.append("Byte");
                    break;
                }
                case 16: {
                    stringWriter.append("Short");
                    break;
                }
                case 32: {
                    stringWriter.append("Int");
                    break;
                }
                default: {
                    throw new Error("Unknown number of bytes: " + variable.getType().getBits());
                }
            }
            stringWriter.append("(").append(variable.getName()).appendIf(variable.getArraySize() > 1, "[_i]").append(");").appendPostfix();
            if (variable.getArraySize() <= 1) continue;
            stringWriter.outdent().appendLine("}");
        }
    }

    public void printDecode(StringWriter stringWriter) {
        for (Variable variable : this.vars) {
            if (VariableStore.canSkipVar(variable)) continue;
            if (variable.getType() instanceof CustomVariableType) {
                stringWriter.appendLine("if(!", variable.getName(), ".decode(_reader)) return false;");
                continue;
            }
            if (variable.getArraySize() > 1) {
                stringWriter.appendLine("for(int _i = 0; _i < ", variable.getArraySize(), "; _i++) {").indent();
            }
            stringWriter.appendPrefix().append(variable.getName()).appendIf(variable.getArraySize() > 1, "[_i]").append(" = _reader.read");
            switch (variable.getType().getBits()) {
                case 1: {
                    stringWriter.append("Boolean");
                    break;
                }
                case 8: {
                    stringWriter.append("Byte");
                    break;
                }
                case 16: {
                    stringWriter.append("Short");
                    break;
                }
                case 32: {
                    stringWriter.append("Int");
                    break;
                }
                default: {
                    throw new Error("Unknown number of bytes: " + variable.getType().getBits());
                }
            }
            stringWriter.append("();").appendPostfix();
            if (variable.getArraySize() <= 1) continue;
            stringWriter.outdent().appendLine("}");
        }
    }

    public void printToString(StringWriter stringWriter) {
        for (Variable variable : this.vars) {
            if (variable.getArraySize() == 1) {
                stringWriter.appendLine("sb.append(\"", variable.getName(), " = \").append(", variable.getName() + ").append('\\t');");
                continue;
            }
            for (int i = 0; i < variable.getArraySize(); ++i) {
                stringWriter.appendLine("sb.append(\"", variable.getName(), "[", i, "] = \").append(", variable.getName(), "[", i, "]).append('\\t');");
            }
        }
    }
}

