/*
 * Decompiled with CFR 0.152.
 */
package org.petitparser.parser.primitive;

import java.util.Objects;
import org.petitparser.context.Context;
import org.petitparser.context.Result;
import org.petitparser.parser.Parser;
import org.petitparser.parser.primitive.CharacterPredicate;

public class CharacterParser
extends Parser {
    private final CharacterPredicate matcher;
    private final String message;

    public static Parser of(CharacterPredicate predicate, String message) {
        return new CharacterParser(predicate, message);
    }

    public static Parser of(char character) {
        return CharacterParser.of(character, "'" + character + "' expected");
    }

    public static Parser of(char character, String message) {
        return CharacterParser.of(CharacterPredicate.of(character), message);
    }

    public static Parser any() {
        return CharacterParser.any("any character expected");
    }

    public static Parser any(String message) {
        return CharacterParser.of(CharacterPredicate.any(), message);
    }

    public static Parser anyOf(String chars) {
        return CharacterParser.anyOf(chars, "any of '" + chars + "' expected");
    }

    public static Parser anyOf(String chars, String message) {
        return CharacterParser.of(CharacterPredicate.anyOf(chars), message);
    }

    public static Parser none() {
        return CharacterParser.none("no character expected");
    }

    public static Parser none(String message) {
        return CharacterParser.of(CharacterPredicate.none(), message);
    }

    public static Parser noneOf(String chars) {
        return CharacterParser.noneOf(chars, "none of '" + chars + "' expected");
    }

    public static Parser noneOf(String chars, String message) {
        return CharacterParser.of(CharacterPredicate.noneOf(chars), message);
    }

    public static Parser digit() {
        return CharacterParser.digit("digit expected");
    }

    public static Parser digit(String message) {
        return new CharacterParser(Character::isDigit, message);
    }

    public static Parser letter() {
        return CharacterParser.letter("letter expected");
    }

    public static Parser letter(String message) {
        return CharacterParser.of(Character::isLetter, message);
    }

    public static Parser lowerCase() {
        return CharacterParser.lowerCase("lowercase letter expected");
    }

    public static Parser lowerCase(String message) {
        return CharacterParser.of(Character::isLowerCase, message);
    }

    public static Parser pattern(String pattern) {
        return CharacterParser.pattern(pattern, "[" + pattern + "] expected");
    }

    public static Parser pattern(String pattern, String message) {
        return CharacterParser.of(CharacterPredicate.pattern(pattern), message);
    }

    public static Parser range(char start, char stop) {
        return CharacterParser.range(start, stop, start + ".." + stop + " expected");
    }

    public static Parser range(char start, char stop, String message) {
        return CharacterParser.of(CharacterPredicate.range(start, stop), message);
    }

    public static Parser upperCase() {
        return CharacterParser.upperCase("uppercase letter expected");
    }

    public static Parser upperCase(String message) {
        return CharacterParser.of(Character::isUpperCase, message);
    }

    public static Parser whitespace() {
        return CharacterParser.whitespace("whitespace expected");
    }

    public static Parser whitespace(String message) {
        return CharacterParser.of(Character::isWhitespace, message);
    }

    public static Parser word() {
        return CharacterParser.word("letter or digit expected");
    }

    public static Parser word(String message) {
        return CharacterParser.of(Character::isLetterOrDigit, message);
    }

    private CharacterParser(CharacterPredicate matcher, String message) {
        this.matcher = Objects.requireNonNull(matcher, "Undefined matcher");
        this.message = Objects.requireNonNull(message, "Undefined message");
    }

    @Override
    public Result parseOn(Context context) {
        char result;
        String buffer = context.getBuffer();
        int position = context.getPosition();
        if (position < buffer.length() && this.matcher.test(result = buffer.charAt(position))) {
            return context.success(Character.valueOf(result), position + 1);
        }
        return context.failure(this.message);
    }

    @Override
    public Parser neg(String message) {
        return CharacterParser.of(this.matcher.not(), message);
    }

    @Override
    protected boolean hasEqualProperties(Parser other) {
        return super.hasEqualProperties(other) && Objects.equals(this.matcher, ((CharacterParser)other).matcher) && Objects.equals(this.message, ((CharacterParser)other).message);
    }

    @Override
    public Parser copy() {
        return CharacterParser.of(this.matcher, this.message);
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this.message + "]";
    }
}

